/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.HttpResponseWrapper;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.WriteTimeoutException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseCompleteException;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.ClosedStreamExceptionUtil;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpRequestHandler
implements ChannelFutureListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpRequestHandler.class);
    private final Channel ch;
    private final ClientHttpObjectEncoder encoder;
    private final HttpResponseDecoder responseDecoder;
    private final DecodedHttpResponse originalRes;
    private final ClientRequestContext ctx;
    private final RequestLogBuilder logBuilder;
    private final long timeoutMillis;
    private final boolean headersOnly;
    private final boolean allowTrailers;
    private final boolean keepAlive;
    @Nullable
    private HttpSession session;
    private int id = -1;
    @Nullable
    private HttpResponseWrapper responseWrapper;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    private State state = State.NEEDS_TO_WRITE_FIRST_HEADER;
    private boolean loggedRequestFirstBytesTransferred;

    AbstractHttpRequestHandler(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis, boolean headersOnly, boolean allowTrailers, boolean keepAlive) {
        this.ch = ch;
        this.encoder = encoder;
        this.responseDecoder = responseDecoder;
        this.originalRes = originalRes;
        this.ctx = ctx;
        this.logBuilder = ctx.logBuilder();
        this.timeoutMillis = timeoutMillis;
        this.headersOnly = headersOnly;
        this.allowTrailers = allowTrailers;
        this.keepAlive = keepAlive;
    }

    abstract void onWriteSuccess();

    abstract void cancel();

    final Channel channel() {
        return this.ch;
    }

    final int id() {
        return this.id;
    }

    final State state() {
        return this.state;
    }

    public final void operationComplete(ChannelFuture future) throws Exception {
        this.cancelTimeout();
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            if (future.isSuccess()) {
                if (!this.loggedRequestFirstBytesTransferred) {
                    this.logBuilder.requestFirstBytesTransferred();
                    this.loggedRequestFirstBytesTransferred = true;
                }
                if (this.state == State.DONE) {
                    this.logBuilder.endRequest();
                    assert (this.responseWrapper != null);
                    this.responseWrapper.initTimeout();
                }
                this.onWriteSuccess();
                return;
            }
            if (!this.loggedRequestFirstBytesTransferred) {
                this.fail(UnprocessedRequestException.of(future.cause()));
            } else {
                this.failAndReset(future.cause());
            }
        }
    }

    final boolean tryInitialize() {
        HttpSession session = HttpSession.get(this.ch);
        this.id = session.incrementAndGetNumRequestsSent();
        if (this.id >= 0x20000000 || !session.canSendRequest()) {
            ClosedSessionException exception = this.id >= 0x20000000 ? new ClosedSessionException("Can't send requests more than 536870912 in one connection. ID: " + this.id) : new ClosedSessionException("Can't send requests. ID: " + this.id + ", session active: " + session.isAcquirable(this.responseDecoder.keepAliveHandler()));
            session.deactivate();
            this.fail(UnprocessedRequestException.of(exception));
            return false;
        }
        this.session = session;
        this.responseWrapper = this.responseDecoder.addResponse(this.id, this.originalRes, this.ctx, this.ch.eventLoop());
        if (this.timeoutMillis > 0L) {
            this.timeoutFuture = this.ch.eventLoop().schedule(() -> this.failAndReset(WriteTimeoutException.get()), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    final void writeHeaders(RequestHeaders headers) {
        SessionProtocol protocol = this.session.protocol();
        assert (protocol != null);
        this.state = this.headersOnly ? State.DONE : (this.allowTrailers ? State.NEEDS_DATA_OR_TRAILERS : State.NEEDS_DATA);
        ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
        HttpHeaders internalHeaders = ctxExtension == null ? HttpHeaders.of() : ctxExtension.internalRequestHeaders();
        RequestHeaders merged = HttpHeadersUtil.mergeRequestHeaders(headers, this.ctx.defaultRequestHeaders(), this.ctx.additionalRequestHeaders(), internalHeaders);
        this.logBuilder.requestHeaders(merged);
        String connectionOption = headers.get((CharSequence)HttpHeaderNames.CONNECTION);
        if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption) || !this.keepAlive) {
            this.session.deactivate();
        }
        ChannelPromise promise = this.ch.newPromise();
        promise.addListener((GenericFutureListener)this);
        this.encoder.writeHeaders(this.id, this.streamId(), merged, this.headersOnly, promise);
    }

    final void writeData(HttpData data) {
        data.touch(this.ctx);
        this.logBuilder.increaseRequestLength(data);
        this.write(data, data.isEndOfStream());
    }

    final void writeTrailers(HttpHeaders trailers) {
        this.logBuilder.requestTrailers(trailers);
        this.write(trailers, true);
    }

    private void write(HttpObject o, boolean endOfStream) {
        if (!this.ch.isActive()) {
            PooledObjects.close(o);
            this.fail(ClosedStreamExceptionUtil.newClosedSessionException(this.ch));
            return;
        }
        if (endOfStream) {
            this.state = State.DONE;
        }
        if (this.isStreamOrSessionClosed()) {
            PooledObjects.close(o);
            return;
        }
        ChannelFuture future = o instanceof HttpHeaders ? this.encoder.writeTrailers(this.id, this.streamId(), (HttpHeaders)o) : this.encoder.writeData(this.id, this.streamId(), (HttpData)o, endOfStream);
        future.addListener((GenericFutureListener)this);
    }

    private boolean isStreamOrSessionClosed() {
        if (!this.encoder.isWritable(this.id, this.streamId())) {
            if (this.ctx.sessionProtocol().isMultiplex()) {
                this.failAndReset(ClosedStreamExceptionUtil.newClosedStreamException(this.ch));
            } else {
                this.failAndReset(ClosedStreamExceptionUtil.newClosedSessionException(this.ch));
            }
            return true;
        }
        return false;
    }

    private int streamId() {
        return (this.id << 1) + 1;
    }

    final void failRequest(Throwable cause) {
        if (this.id() >= 0) {
            this.failAndReset(cause);
        } else {
            this.fail(UnprocessedRequestException.of(cause));
        }
    }

    private void fail(Throwable cause) {
        this.state = State.DONE;
        this.cancel();
        this.logBuilder.endRequest(cause);
        if (this.responseWrapper != null) {
            if (this.responseWrapper.isOpen()) {
                this.responseWrapper.close(cause);
            } else {
                this.logBuilder.endResponse(cause);
            }
        } else {
            this.logBuilder.endResponse(cause);
            this.originalRes.close(cause);
        }
    }

    final void failAndReset(Throwable cause) {
        if (cause instanceof ProxyConnectException || cause instanceof ResponseCompleteException) {
            this.state = State.DONE;
            this.cancel();
            this.logBuilder.endRequest(cause);
            return;
        }
        this.fail(cause);
        Http2Error error = Exceptions.isStreamCancelling(cause) ? Http2Error.CANCEL : Http2Error.INTERNAL_ERROR;
        if (error.code() != Http2Error.CANCEL.code()) {
            Exceptions.logIfUnexpected(logger, this.ch, HttpSession.get(this.ch).protocol(), "a request publisher raised an exception", cause);
        }
        if (this.ch.isActive()) {
            this.encoder.writeReset(this.id, this.streamId(), error, false);
            this.ch.flush();
        }
    }

    final boolean cancelTimeout() {
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture == null) {
            return true;
        }
        this.timeoutFuture = null;
        return timeoutFuture.cancel(false);
    }

    static enum State {
        NEEDS_TO_WRITE_FIRST_HEADER,
        NEEDS_DATA,
        NEEDS_DATA_OR_TRAILERS,
        DONE;

    }
}

