/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.parser.impl.SqlParserImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.PrecedenceClimbingParser;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public final class SqlParserUtil {
    static final Logger LOGGER = CalciteTrace.getParserTracer();
    private static final Pattern UNDERSCORE = Pattern.compile("_+");

    private SqlParserUtil() {
    }

    public static @Nullable String getCharacterSet(String s) {
        if (s.charAt(0) == '\'') {
            return null;
        }
        if (Character.toUpperCase(s.charAt(0)) == 'N') {
            return CalciteSystemProperty.DEFAULT_NATIONAL_CHARSET.value();
        }
        int i = s.indexOf("'");
        return s.substring(1, i);
    }

    public static String parseString(String s) {
        int i = s.indexOf("'");
        if (i > 0) {
            s = s.substring(i);
        }
        return SqlParserUtil.strip(s, "'", "'", "''", Casing.UNCHANGED);
    }

    public static String parseCString(String s) throws MalformedUnicodeEscape {
        String s2 = SqlParserUtil.parseString(s);
        return SqlParserUtil.replaceEscapedChars(s2);
    }

    public static String replaceEscapedChars(String input) throws MalformedUnicodeEscape {
        int length = input.length();
        if (length <= 1) {
            return input;
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == '\\' && i + 1 < length) {
                char nextChar = input.charAt(i + 1);
                switch (nextChar) {
                    case 'b': {
                        builder.append('\b');
                        ++i;
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        ++i;
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        ++i;
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        ++i;
                        break;
                    }
                    case '\'': 
                    case '\\': {
                        builder.append(nextChar);
                        ++i;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        int charsToConsume;
                        int n = charsToConsume = nextChar == 'u' ? 4 : 8;
                        if (i + 1 + charsToConsume >= length) {
                            throw new MalformedUnicodeEscape(i);
                        }
                        int endIdx = SqlParserUtil.calculateMaxCharsInSequence(input, i + 2, charsToConsume, SqlParserUtil::isHexDigit);
                        if (endIdx != i + 2 + charsToConsume) {
                            throw new MalformedUnicodeEscape(i);
                        }
                        builder.appendCodePoint(Integer.parseInt(input.substring(i + 2, endIdx), 16));
                        i = endIdx - 1;
                        break;
                    }
                    case 'x': {
                        int endIdx = SqlParserUtil.calculateMaxCharsInSequence(input, i + 2, 2, SqlParserUtil::isHexDigit);
                        if (endIdx > i + 2) {
                            builder.appendCodePoint(Integer.parseInt(input.substring(i + 2, endIdx), 16));
                            i = endIdx - 1;
                            break;
                        }
                        builder.append(nextChar);
                        ++i;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        int endIdx = SqlParserUtil.calculateMaxCharsInSequence(input, i + 2, 2, SqlParserUtil::isOctalDigit);
                        builder.appendCodePoint(Integer.parseInt(input.substring(i + 1, endIdx), 8));
                        i = endIdx - 1;
                        break;
                    }
                    default: {
                        builder.append(currentChar);
                        break;
                    }
                }
                continue;
            }
            builder.append(currentChar);
        }
        return builder.toString();
    }

    private static int calculateMaxCharsInSequence(CharSequence seq, int beginIndex, int maxCharsToMatch, Predicate<Character> predicate) {
        int idx;
        int end = Math.min(seq.length(), beginIndex + maxCharsToMatch);
        for (idx = beginIndex; idx < end && predicate.test(Character.valueOf(seq.charAt(idx))); ++idx) {
        }
        return idx;
    }

    public static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s);
    }

    public static BigDecimal parseInteger(String s) {
        return new BigDecimal(s);
    }

    public static boolean isOctalDigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    public static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    @Deprecated
    public static Date parseDate(String s) {
        return Date.valueOf(s);
    }

    @Deprecated
    public static Time parseTime(String s) {
        return Time.valueOf(s);
    }

    @Deprecated
    public static Timestamp parseTimestamp(String s) {
        return Timestamp.valueOf(s);
    }

    public static SqlDateLiteral parseDateLiteral(String s, SqlParserPos pos) {
        Calendar cal = DateTimeUtils.parseDateFormat((String)s, (DateFormat)Format.get().date, (TimeZone)DateTimeUtils.UTC_ZONE);
        if (cal == null) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalLiteral("DATE", s, Static.RESOURCE.badFormat("yyyy-MM-dd").str()));
        }
        DateString d = DateString.fromCalendarFields(cal);
        return SqlLiteral.createDate(d, pos);
    }

    public static SqlNumericLiteral parseDecimalLiteral(String s, SqlParserPos pos) {
        try {
            s = new BigDecimal(s).toPlainString();
        }
        catch (NumberFormatException e) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.invalidLiteral(s, "DECIMAL"));
        }
        return SqlLiteral.createExactNumeric(s, pos);
    }

    public static SqlTimeLiteral parseTimeLiteral(String s, SqlParserPos pos) {
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral((String)s, (DateFormat)Format.get().time, (TimeZone)DateTimeUtils.UTC_ZONE, (int)-1);
        if (pt == null) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalLiteral("TIME", s, Static.RESOURCE.badFormat("HH:mm:ss").str()));
        }
        TimeString t = TimeString.fromCalendarFields(pt.getCalendar()).withFraction(pt.getFraction());
        return SqlLiteral.createTime(t, pt.getPrecision(), pos);
    }

    public static SqlTimestampLiteral parseTimestampLiteral(String s, SqlParserPos pos) {
        return SqlParserUtil.parseTimestampLiteral(SqlTypeName.TIMESTAMP, s, pos);
    }

    public static SqlTimestampLiteral parseTimestampWithLocalTimeZoneLiteral(String s, SqlParserPos pos) {
        return SqlParserUtil.parseTimestampLiteral(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, s, pos);
    }

    private static SqlTimestampLiteral parseTimestampLiteral(SqlTypeName typeName, String s, SqlParserPos pos) {
        DateFormat dateFormat;
        DateFormat[] dateFormats;
        Format format = Format.get();
        DateTimeUtils.PrecisionTime pt = null;
        DateFormat[] dateFormatArray = dateFormats = new DateFormat[]{format.timestamp, format.date};
        int n = dateFormatArray.length;
        for (int i = 0; i < n && (pt = DateTimeUtils.parsePrecisionDateTimeLiteral((String)s, (DateFormat)(dateFormat = dateFormatArray[i]), (TimeZone)DateTimeUtils.UTC_ZONE, (int)-1)) == null; ++i) {
        }
        if (pt == null) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalLiteral(typeName.getName().replace('_', ' '), s, Static.RESOURCE.badFormat("yyyy-MM-dd HH:mm:ss").str()));
        }
        TimestampString ts = TimestampString.fromCalendarFields(pt.getCalendar()).withFraction(pt.getFraction());
        return SqlLiteral.createTimestamp(typeName, ts, pt.getPrecision(), pos);
    }

    public static SqlIntervalLiteral parseIntervalLiteral(SqlParserPos pos, int sign, String s, SqlIntervalQualifier intervalQualifier) {
        if (s.equals("")) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalIntervalLiteral(s + " " + intervalQualifier.toString(), pos.toString()));
        }
        return SqlLiteral.createInterval(sign, s, intervalQualifier, pos);
    }

    public static SqlNode parseArrayLiteral(String s) throws SqlParseException {
        SqlAbstractParserImpl parser = SqlParserImpl.FACTORY.getParser(new StringReader(s));
        return parser.parseArray();
    }

    public static void checkDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ROOT);
        Util.discard(df);
    }

    public static long intervalToMillis(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMillis(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMillis(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Preconditions.checkArgument((!intervalQualifier.isYearMonth() ? 1 : 0) != 0, (Object)"interval must be day time");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition(), RelDataTypeSystem.DEFAULT);
        }
        catch (CalciteContextException e) {
            throw new RuntimeException("while parsing day-to-second interval " + literal, e);
        }
        long l = 0L;
        long[] conv = new long[5];
        conv[4] = 1L;
        conv[3] = conv[4] * 1000L;
        conv[2] = conv[3] * 60L;
        conv[1] = conv[2] * 60L;
        conv[0] = conv[1] * 24L;
        for (int i = 1; i < ret.length; ++i) {
            l += conv[i - 1] * (long)ret[i];
        }
        return (long)ret[0] * l;
    }

    public static long intervalToMonths(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMonths(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMonths(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Preconditions.checkArgument((boolean)intervalQualifier.isYearMonth(), (Object)"interval must be year month");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition(), RelDataTypeSystem.DEFAULT);
        }
        catch (CalciteContextException e) {
            throw new RuntimeException("Error while parsing year-to-month interval " + literal, e);
        }
        long l = 0L;
        long[] conv = new long[2];
        conv[1] = 1L;
        conv[0] = conv[1] * 12L;
        for (int i = 1; i < ret.length; ++i) {
            l += conv[i - 1] * (long)ret[i];
        }
        return (long)ret[0] * l;
    }

    public static int parsePositiveInt(String value) {
        if ((value = value.trim()).charAt(0) == '-') {
            throw new NumberFormatException(value);
        }
        return Integer.parseInt(value);
    }

    @Deprecated
    public static byte[] parseBinaryString(String s) {
        s = s.replace(" ", "");
        s = s.replace("\n", "");
        s = s.replace("\t", "");
        s = s.replace("\r", "");
        s = s.replace("\f", "");
        if ((s = s.replace("'", "")).length() == 0) {
            return new byte[0];
        }
        assert ((s.length() & 1) == 0);
        int lengthToBe = s.length() / 2;
        s = "ff" + s;
        BigInteger bigInt = new BigInteger(s, 16);
        byte[] ret = new byte[lengthToBe];
        System.arraycopy(bigInt.toByteArray(), 2, ret, 0, ret.length);
        return ret;
    }

    public static String strip(String s, @Nullable String startQuote, @Nullable String endQuote, @Nullable String escape, Casing casing) {
        if (startQuote != null) {
            return SqlParserUtil.stripQuotes(s, startQuote, Objects.requireNonNull(endQuote, "endQuote"), Objects.requireNonNull(escape, "escape"), casing);
        }
        return SqlParserUtil.toCase(s, casing);
    }

    public static String stripQuotes(String s, String startQuote, String endQuote, String escape, Casing casing) {
        assert (startQuote.length() == 1);
        assert (endQuote.length() == 1);
        assert (s.startsWith(startQuote) && s.endsWith(endQuote)) : s;
        s = s.substring(1, s.length() - 1).replace(escape, endQuote);
        return SqlParserUtil.toCase(s, casing);
    }

    public static String toCase(String s, Casing casing) {
        switch (casing) {
            case TO_UPPER: {
                return s.toUpperCase(Locale.ROOT);
            }
            case TO_LOWER: {
                return s.toLowerCase(Locale.ROOT);
            }
        }
        return s;
    }

    public static String trim(String s, String chars) {
        char c;
        int stop;
        char c2;
        int start;
        if (s.length() == 0) {
            return "";
        }
        for (start = 0; start < s.length() && chars.indexOf(c2 = s.charAt(start)) >= 0; ++start) {
        }
        for (stop = s.length(); stop > start && chars.indexOf(c = s.charAt(stop - 1)) >= 0; --stop) {
        }
        if (start >= stop) {
            return "";
        }
        return s.substring(start, stop);
    }

    @Deprecated
    public static StringAndPos findPos(String sql) {
        return StringAndPos.of(sql);
    }

    public static int[] indexToLineCol(String sql, int i) {
        int line = 0;
        int j = 0;
        while (true) {
            int prevj = j;
            if ((j = SqlParserUtil.nextLine(sql, j)) < 0 || j > i) {
                return new int[]{line + 1, i - prevj + 1};
            }
            ++line;
        }
    }

    public static int nextLine(String sql, int j) {
        int rn = sql.indexOf("\r\n", j);
        int r = sql.indexOf("\r", j);
        int n = sql.indexOf("\n", j);
        if (r < 0 && n < 0) {
            assert (rn < 0);
            return -1;
        }
        if (rn >= 0 && rn < n && rn <= r) {
            return rn + 2;
        }
        if (r >= 0 && r < n) {
            return r + 1;
        }
        return n + 1;
    }

    public static int lineColToIndex(String sql, int line, int column) {
        --column;
        int i = 0;
        while (true) {
            int n = --line;
            --line;
            if (n <= 0) break;
            i = SqlParserUtil.nextLine(sql, i);
        }
        return i + column;
    }

    public static String addCarets(String sql, int line, int col, int endLine, int endCol) {
        int cut = SqlParserUtil.lineColToIndex(sql, line, col);
        String sqlWithCarets = sql.substring(0, cut) + "^" + sql.substring(cut);
        if (col != endCol || line != endLine) {
            cut = SqlParserUtil.lineColToIndex(sqlWithCarets, endLine, endCol);
            if (line == endLine) {
                ++cut;
            }
            sqlWithCarets = cut < sqlWithCarets.length() ? sqlWithCarets.substring(0, cut) + "^" + sqlWithCarets.substring(cut) : sqlWithCarets + "^";
        }
        return sqlWithCarets;
    }

    public static @Nullable String getTokenVal(String token) {
        int endIndex;
        if (!token.startsWith("\"")) {
            return null;
        }
        int startIndex = token.indexOf("\"");
        String tokenVal = token.substring(startIndex + 1, endIndex = token.lastIndexOf("\""));
        char c = tokenVal.charAt(0);
        if (Character.isLetter(c)) {
            return tokenVal;
        }
        return null;
    }

    public static ParsedCollation parseCollation(String in) {
        StringTokenizer st = new StringTokenizer(in, "$");
        String charsetStr = st.nextToken();
        String localeStr = st.nextToken();
        String strength = st.countTokens() > 0 ? st.nextToken() : CalciteSystemProperty.DEFAULT_COLLATION_STRENGTH.value();
        Charset charset = SqlUtil.getCharset(charsetStr);
        try {
            Locale locale = new Locale.Builder().setLanguageTag(UNDERSCORE.matcher(localeStr).replaceAll("-")).build();
            return new ParsedCollation(charset, locale, strength);
        }
        catch (IllformedLocaleException e) {
            throw Static.RESOURCE.illegalLocaleFormat(localeStr).ex();
        }
    }

    @Deprecated
    public static String[] toStringArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static SqlNode[] toNodeArray(List<SqlNode> list) {
        return list.toArray(new SqlNode[0]);
    }

    public static SqlNode[] toNodeArray(SqlNodeList list) {
        return list.toArray(new SqlNode[0]);
    }

    public static SqlNodeList stripRow(SqlNode n) {
        Object list;
        switch (n.getKind()) {
            case ROW: {
                list = ((SqlCall)n).getOperandList();
                break;
            }
            default: {
                list = ImmutableList.of((Object)n);
            }
        }
        return new SqlNodeList((Collection<? extends SqlNode>)list, n.getParserPosition());
    }

    @Deprecated
    public static String rightTrim(String s, char c) {
        int stop;
        for (stop = s.length(); stop > 0 && s.charAt(stop - 1) == c; --stop) {
        }
        if (stop > 0) {
            return s.substring(0, stop);
        }
        return "";
    }

    public static <T> void replaceSublist(List<T> list, int start, int end, T o) {
        Objects.requireNonNull(list, "list");
        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
        for (int i = end - 1; i > start; --i) {
            list.remove(i);
        }
        list.set(start, o);
    }

    public static @Nullable SqlNode toTree(List<@Nullable Object> list) {
        if (list.size() == 1 && list.get(0) instanceof SqlNode) {
            return (SqlNode)list.get(0);
        }
        LOGGER.trace("Attempting to reduce {}", list);
        OldTokenSequenceImpl tokenSequence = new OldTokenSequenceImpl(list);
        SqlNode node = SqlParserUtil.toTreeEx(tokenSequence, 0, 0, SqlKind.OTHER);
        LOGGER.debug("Reduced {}", (Object)node);
        return node;
    }

    public static SqlNode toTreeEx(SqlSpecialOperator.TokenSequence list, int start, int minPrec, SqlKind stopperKind) {
        PrecedenceClimbingParser parser = list.parser(start, token -> {
            if (token instanceof PrecedenceClimbingParser.Op) {
                PrecedenceClimbingParser.Op tokenOp = (PrecedenceClimbingParser.Op)token;
                SqlOperator op = ((ToTreeListItem)tokenOp.o()).op;
                return stopperKind != SqlKind.OTHER && op.kind == stopperKind || minPrec > 0 && op.getLeftPrec() < minPrec;
            }
            return false;
        });
        int beforeSize = parser.all().size();
        parser.partialParse();
        int afterSize = parser.all().size();
        SqlNode node = SqlParserUtil.convert(parser.all().get(0));
        list.replaceSublist(start, start + beforeSize - afterSize + 1, node);
        return node;
    }

    private static SqlNode convert(PrecedenceClimbingParser.Token token) {
        switch (token.type) {
            case ATOM: {
                return Objects.requireNonNull((SqlNode)token.o);
            }
            case CALL: {
                PrecedenceClimbingParser.Call call = (PrecedenceClimbingParser.Call)token;
                ArrayList<SqlNode> list = new ArrayList<SqlNode>();
                for (PrecedenceClimbingParser.Token arg : call.args) {
                    list.add(SqlParserUtil.convert(arg));
                }
                ToTreeListItem item = (ToTreeListItem)call.op.o();
                if (list.size() == 1) {
                    SqlNode firstItem = (SqlNode)list.get(0);
                    if (item.op == SqlStdOperatorTable.UNARY_MINUS && firstItem instanceof SqlNumericLiteral) {
                        return SqlLiteral.createNegative((SqlNumericLiteral)firstItem, item.pos.plusAll(list));
                    }
                    if (item.op == SqlStdOperatorTable.UNARY_PLUS && firstItem instanceof SqlNumericLiteral) {
                        return firstItem;
                    }
                }
                return item.op.createCall(item.pos.plusAll(list), list);
            }
        }
        throw new AssertionError(token);
    }

    public static char checkUnicodeEscapeChar(String s) {
        if (s.length() != 1) {
            throw Static.RESOURCE.unicodeEscapeCharLength(s).ex();
        }
        char c = s.charAt(0);
        if (Character.isDigit(c) || Character.isWhitespace(c) || c == '+' || c == '\"' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            throw Static.RESOURCE.unicodeEscapeCharIllegal(s).ex();
        }
        return c;
    }

    public static boolean allowsIdentifier(String[] tokenImage, int[][] expectedTokenSequences) {
        for (int i = expectedTokenSequences.length - 1; i >= 0; --i) {
            int[] expectedTokenSequence = expectedTokenSequences[i];
            for (int j = expectedTokenSequence.length - 1; j >= 0; --j) {
                if (!tokenImage[expectedTokenSequence[j]].equals("<IDENTIFIER>")) continue;
                return true;
            }
        }
        return false;
    }

    public static class MalformedUnicodeEscape
    extends Exception {
        public final int i;

        MalformedUnicodeEscape(int i) {
            this.i = i;
        }
    }

    private static class Format {
        private static final ThreadLocal<@Nullable Format> PER_THREAD = ThreadLocal.withInitial(Format::new);
        final DateFormat timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        final DateFormat time = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
        final DateFormat date = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);

        private Format() {
        }

        private static Format get() {
            return Objects.requireNonNull(PER_THREAD.get(), "PER_THREAD.get()");
        }
    }

    private static class OldTokenSequenceImpl
    implements SqlSpecialOperator.TokenSequence {
        final List<@Nullable Object> list;

        private OldTokenSequenceImpl(List<@Nullable Object> list) {
            this.list = list;
        }

        @Override
        public PrecedenceClimbingParser parser(int start, Predicate<PrecedenceClimbingParser.Token> predicate) {
            PrecedenceClimbingParser.Builder builder = new PrecedenceClimbingParser.Builder();
            for (Object o : Util.skip(this.list, start)) {
                if (o instanceof ToTreeListItem) {
                    ToTreeListItem item = (ToTreeListItem)o;
                    SqlOperator op = item.getOperator();
                    if (op instanceof SqlPrefixOperator) {
                        builder.prefix(item, op.getLeftPrec());
                        continue;
                    }
                    if (op instanceof SqlPostfixOperator) {
                        builder.postfix(item, op.getRightPrec());
                        continue;
                    }
                    if (op instanceof SqlBinaryOperator) {
                        builder.infix(item, op.getLeftPrec(), op.getLeftPrec() < op.getRightPrec());
                        continue;
                    }
                    if (op instanceof SqlSpecialOperator) {
                        builder.special(item, op.getLeftPrec(), op.getRightPrec(), (parser, op2) -> {
                            List<PrecedenceClimbingParser.Token> tokens = parser.all();
                            SqlSpecialOperator op1 = (SqlSpecialOperator)Objects.requireNonNull((ToTreeListItem)op2.o, "op2.o").op;
                            SqlSpecialOperator.ReduceResult r = op1.reduceExpr(tokens.indexOf(op2), new TokenSequenceImpl(parser));
                            return new PrecedenceClimbingParser.Result(tokens.get(r.startOrdinal), tokens.get(r.endOrdinal - 1), parser.atom(r.node));
                        });
                        continue;
                    }
                    throw new AssertionError();
                }
                builder.atom(Objects.requireNonNull(o, "o"));
            }
            return builder.build();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public SqlOperator op(int i) {
            ToTreeListItem item = (ToTreeListItem)Objects.requireNonNull(this.list.get(i), () -> "list.get(" + i + ")");
            return item.op;
        }

        @Override
        public SqlParserPos pos(int i) {
            Object o = this.list.get(i);
            return o instanceof ToTreeListItem ? ((ToTreeListItem)o).pos : Objects.requireNonNull((SqlNode)o, () -> "item " + i + " is null in " + this.list).getParserPosition();
        }

        @Override
        public boolean isOp(int i) {
            return this.list.get(i) instanceof ToTreeListItem;
        }

        @Override
        public SqlNode node(int i) {
            return Objects.requireNonNull((SqlNode)this.list.get(i));
        }

        @Override
        public void replaceSublist(int start, int end, SqlNode e) {
            SqlParserUtil.replaceSublist(this.list, start, end, e);
        }
    }

    private static class TokenSequenceImpl
    implements SqlSpecialOperator.TokenSequence {
        final List<PrecedenceClimbingParser.Token> list;
        final PrecedenceClimbingParser parser;

        private TokenSequenceImpl(PrecedenceClimbingParser parser) {
            this.parser = parser;
            this.list = parser.all();
        }

        @Override
        public PrecedenceClimbingParser parser(int start, Predicate<PrecedenceClimbingParser.Token> predicate) {
            return this.parser.copy(start, predicate);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public SqlOperator op(int i) {
            ToTreeListItem o = (ToTreeListItem)Objects.requireNonNull(this.list.get((int)i).o, () -> "list.get(" + i + ").o is null in " + this.list);
            return o.getOperator();
        }

        private static SqlParserPos pos(PrecedenceClimbingParser.Token token) {
            switch (token.type) {
                case ATOM: {
                    return Objects.requireNonNull((SqlNode)token.o, "token.o").getParserPosition();
                }
                case CALL: {
                    PrecedenceClimbingParser.Call call = (PrecedenceClimbingParser.Call)token;
                    SqlParserPos pos = ((ToTreeListItem)call.op.o()).pos;
                    for (PrecedenceClimbingParser.Token arg : call.args) {
                        pos = pos.plus(TokenSequenceImpl.pos(arg));
                    }
                    return pos;
                }
            }
            return Objects.requireNonNull((ToTreeListItem)token.o, "token.o").getPos();
        }

        @Override
        public SqlParserPos pos(int i) {
            return TokenSequenceImpl.pos(this.list.get(i));
        }

        @Override
        public boolean isOp(int i) {
            return this.list.get((int)i).o instanceof ToTreeListItem;
        }

        @Override
        public SqlNode node(int i) {
            return SqlParserUtil.convert(this.list.get(i));
        }

        @Override
        public void replaceSublist(int start, int end, SqlNode e) {
            SqlParserUtil.replaceSublist(this.list, start, end, this.parser.atom(e));
        }
    }

    public static class ToTreeListItem {
        private final SqlOperator op;
        private final SqlParserPos pos;

        public ToTreeListItem(SqlOperator op, SqlParserPos pos) {
            this.op = op;
            this.pos = pos;
        }

        public String toString() {
            return this.op.toString();
        }

        public SqlOperator getOperator() {
            return this.op;
        }

        public SqlParserPos getPos() {
            return this.pos;
        }
    }

    public static class ParsedCollation {
        private final Charset charset;
        private final Locale locale;
        private final String strength;

        public ParsedCollation(Charset charset, Locale locale, String strength) {
            this.charset = charset;
            this.locale = locale;
            this.strength = strength;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getStrength() {
            return this.strength;
        }
    }
}

