/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;

public abstract class SqlSampleSpec {
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);

    protected SqlSampleSpec() {
    }

    public static SqlSampleSpec createNamed(String name) {
        return new SqlSubstitutionSampleSpec(name);
    }

    public static SqlSampleSpec createTableSample(boolean isBernoulli, BigDecimal sampleRate) {
        return new SqlTableSampleSpec(isBernoulli, sampleRate);
    }

    @Deprecated
    public static SqlSampleSpec createTableSample(boolean isBernoulli, float sampleRate) {
        return SqlSampleSpec.createTableSample(isBernoulli, BigDecimal.valueOf(sampleRate));
    }

    public static SqlSampleSpec createTableSample(boolean isBernoulli, BigDecimal sampleRate, int repeatableSeed) {
        return new SqlTableSampleSpec(isBernoulli, sampleRate, true, repeatableSeed);
    }

    @Deprecated
    public static SqlSampleSpec createTableSample(boolean isBernoulli, float sampleRate, int repeatableSeed) {
        return SqlSampleSpec.createTableSample(isBernoulli, BigDecimal.valueOf(sampleRate), repeatableSeed);
    }

    public static class SqlTableSampleSpec
    extends SqlSampleSpec {
        private final boolean bernoulli;
        public final BigDecimal sampleRate;
        private final boolean repeatable;
        private final int repeatableSeed;

        private SqlTableSampleSpec(boolean bernoulli, BigDecimal sampleRate) {
            this(bernoulli, sampleRate, false, 0);
        }

        private SqlTableSampleSpec(boolean bernoulli, BigDecimal sampleRate, boolean repeatable, int repeatableSeed) {
            this.bernoulli = bernoulli;
            this.sampleRate = Objects.requireNonNull(sampleRate, "sampleRate");
            this.repeatable = repeatable;
            this.repeatableSeed = repeatableSeed;
        }

        public boolean isBernoulli() {
            return this.bernoulli;
        }

        @Deprecated
        public float getSamplePercentage() {
            return this.sampleRate.floatValue();
        }

        public boolean isRepeatable() {
            return this.repeatable;
        }

        public int getRepeatableSeed() {
            return this.repeatableSeed;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.bernoulli ? "BERNOULLI" : "SYSTEM");
            b.append('(');
            b.append(this.sampleRate.multiply(ONE_HUNDRED));
            b.append(')');
            if (this.repeatable) {
                b.append(" REPEATABLE(");
                b.append(this.repeatableSeed);
                b.append(')');
            }
            return b.toString();
        }
    }

    public static class SqlSubstitutionSampleSpec
    extends SqlSampleSpec {
        private final String name;

        private SqlSubstitutionSampleSpec(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "SUBSTITUTE(" + CalciteSqlDialect.DEFAULT.quoteStringLiteral(this.name) + ")";
        }
    }
}

