/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related.simple;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.extension.related.RelationType;
import mil.nga.geopackage.extension.related.UserRelatedTable;
import mil.nga.geopackage.extension.related.simple.SimpleAttributesTableMetadata;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;

public class SimpleAttributesTable
extends UserRelatedTable {
    public static final RelationType RELATION_TYPE = RelationType.SIMPLE_ATTRIBUTES;
    public static final String COLUMN_ID = "id";

    public static SimpleAttributesTable create(SimpleAttributesTableMetadata metadata) {
        List<UserCustomColumn> columns = metadata.buildColumns();
        return new SimpleAttributesTable(metadata.getTableName(), columns, metadata.getIdColumnName());
    }

    public static List<UserCustomColumn> createRequiredColumns() {
        return SimpleAttributesTable.createRequiredColumns(UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(boolean autoincrement) {
        return SimpleAttributesTable.createRequiredColumns(null, autoincrement);
    }

    public static List<UserCustomColumn> createRequiredColumns(String idColumnName) {
        return SimpleAttributesTable.createRequiredColumns(idColumnName, UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(String idColumnName, boolean autoincrement) {
        if (idColumnName == null) {
            idColumnName = COLUMN_ID;
        }
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(SimpleAttributesTable.createIdColumn(idColumnName, autoincrement));
        return columns;
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex) {
        return SimpleAttributesTable.createRequiredColumns(startingIndex, UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, boolean autoincrement) {
        return SimpleAttributesTable.createRequiredColumns(startingIndex, null, autoincrement);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, String idColumnName) {
        return SimpleAttributesTable.createRequiredColumns(startingIndex, idColumnName, UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, String idColumnName, boolean autoincrement) {
        if (idColumnName == null) {
            idColumnName = COLUMN_ID;
        }
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(SimpleAttributesTable.createIdColumn(startingIndex++, idColumnName, autoincrement));
        return columns;
    }

    public static UserCustomColumn createIdColumn(String idColumnName) {
        return UserCustomColumn.createPrimaryKeyColumn(idColumnName);
    }

    public static UserCustomColumn createIdColumn(String idColumnName, boolean autoincrement) {
        return UserCustomColumn.createPrimaryKeyColumn(idColumnName, autoincrement);
    }

    public static UserCustomColumn createIdColumn(int index, String idColumnName) {
        return UserCustomColumn.createPrimaryKeyColumn(index, idColumnName);
    }

    public static UserCustomColumn createIdColumn(int index, String idColumnName, boolean autoincrement) {
        return UserCustomColumn.createPrimaryKeyColumn(index, idColumnName, autoincrement);
    }

    public static int numRequiredColumns() {
        return SimpleAttributesTable.requiredColumns().size();
    }

    public static List<String> requiredColumns() {
        return SimpleAttributesTable.requiredColumns(null);
    }

    public static List<String> requiredColumns(String idColumnName) {
        if (idColumnName == null) {
            idColumnName = COLUMN_ID;
        }
        ArrayList<String> requiredColumns = new ArrayList<String>();
        requiredColumns.add(idColumnName);
        return requiredColumns;
    }

    public SimpleAttributesTable(String tableName, List<UserCustomColumn> columns) {
        this(tableName, columns, (String)null);
    }

    public SimpleAttributesTable(String tableName, List<UserCustomColumn> columns, String idColumnName) {
        super(tableName, RELATION_TYPE.getName(), RELATION_TYPE.getDataType(), columns, SimpleAttributesTable.requiredColumns(idColumnName));
        this.validateColumns();
    }

    public SimpleAttributesTable(UserCustomTable table) {
        super(RELATION_TYPE.getName(), RELATION_TYPE.getDataType(), table);
        this.validateColumns();
    }

    private void validateColumns() {
        List columns = this.getColumns();
        if (columns.size() < 2) {
            throw new GeoPackageException("Simple Attributes Tables require at least one non id column. Columns: " + columns.size());
        }
        for (UserCustomColumn column : columns) {
            if (SimpleAttributesTable.isSimple(column)) continue;
            throw new GeoPackageException("Simple Attributes Tables only support simple data types. Column: " + column.getName() + ", Non Simple Data Type: " + column.getDataType().name());
        }
    }

    public int getIdColumnIndex() {
        return this.getPkColumnIndex();
    }

    public UserCustomColumn getIdColumn() {
        return (UserCustomColumn)this.getPkColumn();
    }

    public static boolean isSimple(UserColumn column) {
        return column.isNotNull() && SimpleAttributesTable.isSimple(column.getDataType());
    }

    public static boolean isSimple(GeoPackageDataType dataType) {
        return dataType != GeoPackageDataType.BLOB;
    }
}

