/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.attributes.AttributesTableMetadata;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDao;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.extension.ExtensionManager;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.features.user.FeatureTableMetadata;
import mil.nga.geopackage.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.proj.Projection;

public interface GeoPackageCore
extends Closeable {
    @Override
    public void close();

    public String getName();

    public String getPath();

    public GeoPackageCoreConnection getDatabase();

    public GeoPackageTableCreator getTableCreator();

    public boolean isWritable();

    public String getApplicationId();

    public Integer getApplicationIdInteger();

    public String getApplicationIdHex();

    public Integer getUserVersion();

    public Integer getUserVersionMajor();

    public Integer getUserVersionMinor();

    public Integer getUserVersionPatch();

    public List<String> getFeatureTables();

    public List<String> getTileTables();

    public List<String> getAttributesTables();

    public List<String> getTables(ContentsDataType var1);

    public List<String> getTables(ContentsDataType ... var1);

    public List<String> getTables(String var1);

    public List<String> getTables(String ... var1);

    public List<Contents> getTypeContents(ContentsDataType var1);

    public List<Contents> getTypeContents(ContentsDataType ... var1);

    public List<Contents> getTypeContents(String var1);

    public List<Contents> getTypeContents(String ... var1);

    public List<String> getTables();

    public boolean isFeatureTable(String var1);

    public boolean isTileTable(String var1);

    public boolean isAttributeTable(String var1);

    public boolean isTableType(String var1, ContentsDataType var2);

    public boolean isTableType(String var1, ContentsDataType ... var2);

    public boolean isTableType(String var1, String var2);

    public boolean isTableType(String var1, String ... var2);

    public boolean isContentsTable(String var1);

    public boolean isTable(String var1);

    public boolean isView(String var1);

    public boolean isTableOrView(String var1);

    public Contents getTableContents(String var1);

    public String getTableType(String var1);

    public ContentsDataType getTableDataType(String var1);

    public ContentsDataType getTableCoreDataType(String var1);

    public boolean isTableCoreDataType(String var1);

    public BoundingBox getContentsBoundingBox(Projection var1);

    public BoundingBox getBoundingBox(Projection var1);

    public BoundingBox getBoundingBox(Projection var1, boolean var2);

    public BoundingBox getTableBoundingBox(Projection var1);

    public BoundingBox getTableBoundingBox(Projection var1, boolean var2);

    public BoundingBox getContentsBoundingBox(String var1);

    public BoundingBox getContentsBoundingBox(Projection var1, String var2);

    public BoundingBox getBoundingBox(String var1);

    public BoundingBox getBoundingBox(Projection var1, String var2);

    public BoundingBox getBoundingBox(String var1, boolean var2);

    public BoundingBox getBoundingBox(Projection var1, String var2, boolean var3);

    public BoundingBox getTableBoundingBox(String var1);

    public BoundingBox getTableBoundingBox(Projection var1, String var2);

    public BoundingBox getTableBoundingBox(String var1, boolean var2);

    public BoundingBox getTableBoundingBox(Projection var1, String var2, boolean var3);

    public Projection getContentsProjection(String var1);

    public Projection getProjection(String var1);

    public BoundingBox getFeatureBoundingBox(Projection var1, String var2, boolean var3);

    public SpatialReferenceSystemDao getSpatialReferenceSystemDao();

    public ContentsDao getContentsDao();

    public GeometryColumnsDao getGeometryColumnsDao();

    public boolean createGeometryColumnsTable();

    public void createFeatureTable(FeatureTable var1);

    public FeatureTable createFeatureTable(FeatureTableMetadata var1);

    public TileMatrixSetDao getTileMatrixSetDao();

    public boolean createTileMatrixSetTable();

    public TileMatrixDao getTileMatrixDao();

    public boolean createTileMatrixTable();

    public void createTileTable(TileTable var1);

    public TileTable createTileTable(TileTableMetadata var1);

    public void createAttributesTable(AttributesTable var1);

    public AttributesTable createAttributesTable(AttributesTableMetadata var1);

    public ExtensionsDao getExtensionsDao();

    public boolean createExtensionsTable();

    public void deleteTable(String var1);

    public void deleteTableQuietly(String var1);

    public void verifyWritable();

    public <D extends GeoPackageDao<T, ?>, T> D createDao(Class<T> var1);

    public void execSQL(String var1);

    public void beginTransaction();

    public void endTransaction();

    public void failTransaction();

    public void endTransaction(boolean var1);

    public void endAndBeginTransaction();

    public void commit();

    public boolean inTransaction();

    public <T> T callInTransaction(Callable<T> var1) throws SQLException;

    public boolean enableForeignKeys();

    public boolean foreignKeys();

    public boolean foreignKeys(boolean var1);

    public void dropTable(String var1);

    public void dropView(String var1);

    public void renameTable(String var1, String var2);

    public void copyTable(String var1, String var2);

    public void copyTableNoExtensions(String var1, String var2);

    public void copyTableAsEmpty(String var1, String var2);

    public void vacuum();

    public ExtensionManager getExtensionManager();

    public void createUserTable(UserTable<? extends UserColumn> var1);
}

