/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.postgres;

import java.util.EnumMap;
import java.util.Map;
import org.apache.baremaps.database.schema.DataColumn;

public class PostgresTypeConversion {
    public static final EnumMap<DataColumn.Type, String> typeToName = new EnumMap(DataColumn.Type.class);
    protected static final Map<String, DataColumn.Type> nameToType;

    static {
        typeToName.put(DataColumn.Type.STRING, "varchar");
        typeToName.put(DataColumn.Type.SHORT, "int2");
        typeToName.put(DataColumn.Type.INTEGER, "int4");
        typeToName.put(DataColumn.Type.LONG, "int8");
        typeToName.put(DataColumn.Type.FLOAT, "float4");
        typeToName.put(DataColumn.Type.DOUBLE, "float8");
        typeToName.put(DataColumn.Type.GEOMETRY, "geometry");
        typeToName.put(DataColumn.Type.POINT, "geometry");
        typeToName.put(DataColumn.Type.MULTIPOINT, "geometry");
        typeToName.put(DataColumn.Type.LINESTRING, "geometry");
        typeToName.put(DataColumn.Type.MULTILINESTRING, "geometry");
        typeToName.put(DataColumn.Type.POLYGON, "geometry");
        typeToName.put(DataColumn.Type.MULTIPOLYGON, "geometry");
        typeToName.put(DataColumn.Type.GEOMETRYCOLLECTION, "geometry");
        typeToName.put(DataColumn.Type.INET_ADDRESS, "inet");
        typeToName.put(DataColumn.Type.INET4_ADDRESS, "inet");
        typeToName.put(DataColumn.Type.INET6_ADDRESS, "inet");
        typeToName.put(DataColumn.Type.LOCAL_DATE, "date");
        typeToName.put(DataColumn.Type.LOCAL_TIME, "time");
        typeToName.put(DataColumn.Type.LOCAL_DATE_TIME, "timestamp");
        nameToType = Map.ofEntries(Map.entry("varchar", DataColumn.Type.STRING), Map.entry("int2", DataColumn.Type.SHORT), Map.entry("int4", DataColumn.Type.INTEGER), Map.entry("int8", DataColumn.Type.LONG), Map.entry("float4", DataColumn.Type.FLOAT), Map.entry("float8", DataColumn.Type.DOUBLE), Map.entry("geometry", DataColumn.Type.GEOMETRY), Map.entry("inet", DataColumn.Type.INET6_ADDRESS), Map.entry("date", DataColumn.Type.LOCAL_DATE), Map.entry("time", DataColumn.Type.LOCAL_TIME), Map.entry("timestamp", DataColumn.Type.LOCAL_DATE_TIME));
    }
}

