/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.StringJoiner;

public final class Member {
    private final long ref;
    private final MemberType type;
    private final String role;

    public Member(long ref, MemberType type, String role) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)role);
        this.ref = ref;
        this.type = type;
        this.role = role;
    }

    public long getRef() {
        return this.ref;
    }

    public MemberType getType() {
        return this.type;
    }

    public String getRole() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return this.ref == member.ref && Objects.equal((Object)((Object)this.type), (Object)((Object)member.type)) && Objects.equal((Object)this.role, (Object)member.role);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ref, this.type, this.role});
    }

    public String toString() {
        return new StringJoiner(", ", Member.class.getSimpleName() + "[", "]").add("ref=" + this.ref).add("type='" + this.type.name() + "'").add("role='" + this.role + "'").toString();
    }

    public static enum MemberType {
        NODE,
        WAY,
        RELATION;


        public static MemberType forNumber(int value) {
            switch (value) {
                case 0: {
                    return NODE;
                }
                case 1: {
                    return WAY;
                }
                case 2: {
                    return RELATION;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

