/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowImpl;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.database.type.BooleanDataType;
import org.apache.baremaps.database.type.ByteDataType;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.DoubleDataType;
import org.apache.baremaps.database.type.FloatDataType;
import org.apache.baremaps.database.type.IntegerDataType;
import org.apache.baremaps.database.type.LongDataType;
import org.apache.baremaps.database.type.ShortDataType;
import org.apache.baremaps.database.type.StringDataType;
import org.apache.baremaps.database.type.geometry.CoordinateDataType;
import org.apache.baremaps.database.type.geometry.GeometryCollectionDataType;
import org.apache.baremaps.database.type.geometry.GeometryDataType;
import org.apache.baremaps.database.type.geometry.LineStringDataType;
import org.apache.baremaps.database.type.geometry.MultiLineStringDataType;
import org.apache.baremaps.database.type.geometry.MultiPointDataType;
import org.apache.baremaps.database.type.geometry.MultiPolygonDataType;
import org.apache.baremaps.database.type.geometry.PointDataType;
import org.apache.baremaps.database.type.geometry.PolygonDataType;

public class RowDataType
implements DataType<DataRow> {
    private static final EnumMap<DataColumn.Type, DataType> types = new EnumMap(DataColumn.Type.class);
    private final DataRowType rowType;

    public RowDataType(DataRowType rowType) {
        this.rowType = rowType;
    }

    @Override
    public int size(DataRow row) {
        int size = 4;
        List<DataColumn> columns = this.rowType.columns();
        for (int i = 0; i < columns.size(); ++i) {
            DataColumn.Type columnType = columns.get(i).type();
            DataType dataType = types.get((Object)columnType);
            Object value = row.get(i);
            size += dataType.size(value);
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, DataRow row) {
        int p = position + 4;
        List<DataColumn> columns = this.rowType.columns();
        for (int i = 0; i < columns.size(); ++i) {
            DataColumn column = columns.get(i);
            DataColumn.Type columnType = column.type();
            DataType dataType = types.get((Object)columnType);
            Object value = row.get(i);
            dataType.write(buffer, p, value);
            p += dataType.size(buffer, p);
        }
        buffer.putInt(position, p - position);
    }

    @Override
    public DataRow read(ByteBuffer buffer, int position) {
        int p = position + 4;
        List<DataColumn> columns = this.rowType.columns();
        ArrayList values = new ArrayList();
        for (DataColumn column : columns) {
            DataColumn.Type columnType = column.type();
            DataType dataType = types.get((Object)columnType);
            values.add(dataType.read(buffer, p));
            p += dataType.size(buffer, p);
        }
        return new DataRowImpl(this.rowType, values);
    }

    static {
        types.put(DataColumn.Type.BYTE, new ByteDataType());
        types.put(DataColumn.Type.BOOLEAN, new BooleanDataType());
        types.put(DataColumn.Type.SHORT, new ShortDataType());
        types.put(DataColumn.Type.INTEGER, new IntegerDataType());
        types.put(DataColumn.Type.LONG, new LongDataType());
        types.put(DataColumn.Type.FLOAT, new FloatDataType());
        types.put(DataColumn.Type.DOUBLE, new DoubleDataType());
        types.put(DataColumn.Type.STRING, new StringDataType());
        types.put(DataColumn.Type.GEOMETRY, new GeometryDataType());
        types.put(DataColumn.Type.POINT, new PointDataType());
        types.put(DataColumn.Type.LINESTRING, new LineStringDataType());
        types.put(DataColumn.Type.POLYGON, new PolygonDataType());
        types.put(DataColumn.Type.MULTIPOINT, new MultiPointDataType());
        types.put(DataColumn.Type.MULTILINESTRING, new MultiLineStringDataType());
        types.put(DataColumn.Type.MULTIPOLYGON, new MultiPolygonDataType());
        types.put(DataColumn.Type.GEOMETRYCOLLECTION, new GeometryCollectionDataType());
        types.put(DataColumn.Type.COORDINATE, new CoordinateDataType());
    }
}

