/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.database.type.DataType;

public class DoubleListDataType
implements DataType<List<Double>> {
    @Override
    public int size(List<Double> values) {
        return 4 + values.size() * 8;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Double> values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (double value : values) {
            buffer.putDouble(p, value);
            p += 8;
        }
    }

    @Override
    public List<Double> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 8;
        ArrayList<Double> values = new ArrayList<Double>(length);
        for (int index = 0; index < length; ++index) {
            values.add(buffer.getDouble(position + 4 + index * 8));
        }
        return values;
    }
}

