/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.memory;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.baremaps.database.memory.Memory;
import org.apache.baremaps.database.memory.MemoryException;
import org.apache.baremaps.utils.MappedByteBufferUtils;

public class MemoryMappedFile
extends Memory<MappedByteBuffer> {
    private final Path file;

    public MemoryMappedFile(Path file) {
        this(file, 0x40000000);
    }

    public MemoryMappedFile(Path file, int segmentBytes) {
        super(segmentBytes);
        this.file = file;
    }

    @Override
    protected MappedByteBuffer allocate(int index, int size) {
        MappedByteBuffer mappedByteBuffer;
        block8: {
            FileChannel channel = FileChannel.open(this.file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            try {
                mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, (long)index * (long)size, size);
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MemoryException(e);
                }
            }
            channel.close();
        }
        return mappedByteBuffer;
    }

    @Override
    public void close() throws IOException {
        for (MappedByteBuffer buffer : this.segments) {
            MappedByteBufferUtils.unmap(buffer);
        }
    }

    @Override
    public void clear() throws IOException {
        this.close();
        this.segments.clear();
        Files.delete(this.file);
    }
}

