/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.OutputStream;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;

public final class OutputStreamAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    private static final OutputStreamManagerFactory factory = new OutputStreamManagerFactory();

    private static OutputStreamManager getManager(OutputStream target, boolean follow, Layout layout) {
        OutputStream os = target == null ? OutputStream.nullOutputStream() : new CloseShieldOutputStream(target);
        OutputStream targetRef = target == null ? os : target;
        String managerName = targetRef.getClass().getName() + "@" + Integer.toHexString(targetRef.hashCode()) + "." + follow;
        return OutputStreamManager.getManager(managerName, new FactoryData(os, managerName, layout), factory);
    }

    public static OutputStreamAppenderBuilder newBuilder() {
        return new OutputStreamAppenderBuilder();
    }

    private OutputStreamAppender(String name, Layout layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, true, null, manager);
    }

    private static class FactoryData {
        private final Layout layout;
        private final String name;
        private final OutputStream os;

        public FactoryData(OutputStream os, String type, Layout layout) {
            this.os = os;
            this.name = type;
            this.layout = layout;
        }
    }

    private static class OutputStreamManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private OutputStreamManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            return new OutputStreamManager(data.os, data.name, data.layout, true);
        }
    }

    public static class OutputStreamAppenderBuilder
    extends Builder<OutputStreamAppenderBuilder> {
        public OutputStreamAppender build() {
            Layout layout = this.getOrCreateLayout();
            OutputStreamManager manager = OutputStreamAppender.getManager(this.getTarget(), this.isFollow(), layout);
            return new OutputStreamAppender(this.getName(), layout, this.getFilter(), manager, this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<OutputStreamAppender> {
        private boolean follow = false;
        private OutputStream target;

        public boolean isFollow() {
            return this.follow;
        }

        public OutputStream getTarget() {
            return this.target;
        }

        public B setFollow(boolean shouldFollow) {
            this.follow = shouldFollow;
            return (B)((Builder)this.asBuilder());
        }

        public B setTarget(OutputStream aTarget) {
            this.target = aTarget;
            return (B)((Builder)this.asBuilder());
        }
    }
}

