/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalYearMonthFromFieldsNode
extends JavaScriptBaseNode {
    @Node.Child
    private GetMethodNode getMethodYearMonthFromFieldsNode;
    @Node.Child
    private JSFunctionCallNode callYearMonthFromFieldsNode;

    protected TemporalYearMonthFromFieldsNode(JSContext ctx) {
        this.getMethodYearMonthFromFieldsNode = GetMethodNode.create(ctx, TemporalUtil.YEAR_MONTH_FROM_FIELDS);
        this.callYearMonthFromFieldsNode = JSFunctionCallNode.createCall();
    }

    public abstract JSTemporalPlainYearMonthObject execute(JSDynamicObject var1, JSDynamicObject var2, JSDynamicObject var3);

    @Specialization
    protected JSTemporalPlainYearMonthObject yearMonthFromFields(JSDynamicObject calendar, JSDynamicObject fields, JSDynamicObject options, @Cached InlinedBranchProfile errorBranch) {
        assert (options != null);
        Object fn = this.getMethodYearMonthFromFieldsNode.executeWithTarget((Object)calendar);
        Object yearMonth = this.callYearMonthFromFieldsNode.executeCall(JSArguments.create((Object)calendar, fn, new Object[]{fields, options}));
        return this.requireTemporalYearMonth(yearMonth, errorBranch);
    }

    private JSTemporalPlainYearMonthObject requireTemporalYearMonth(Object obj, InlinedBranchProfile errorBranch) {
        if (!(obj instanceof JSTemporalPlainYearMonthObject)) {
            errorBranch.enter((Node)this);
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
        return (JSTemporalPlainYearMonthObject)obj;
    }
}

