/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Map;

public class HstoreValueHandler
extends BaseValueHandler<Map<String, String>> {
    @Override
    protected void internalHandle(DataOutputStream buffer, Map<String, String> value) throws Exception {
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        DataOutputStream hstoreOutput = new DataOutputStream(byteArrayOutput);
        hstoreOutput.writeInt(value.size());
        for (Map.Entry<String, String> entry : value.entrySet()) {
            this.writeKey(hstoreOutput, entry.getKey());
            this.writeValue(hstoreOutput, entry.getValue());
        }
        buffer.writeInt(byteArrayOutput.size());
        buffer.write(byteArrayOutput.toByteArray());
    }

    private void writeKey(DataOutputStream buffer, String key) throws Exception {
        this.writeText(buffer, key);
    }

    private void writeValue(DataOutputStream buffer, String value) throws Exception {
        if (value == null) {
            buffer.writeInt(-1);
        } else {
            this.writeText(buffer, value);
        }
    }

    private void writeText(DataOutputStream buffer, String text) throws Exception {
        byte[] textBytes = StringUtils.getUtf8Bytes(text);
        buffer.writeInt(textBytes.length);
        buffer.write(textBytes);
    }

    @Override
    public int getLength(Map<String, String> value) {
        throw new UnsupportedOperationException();
    }
}

