/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.client.api.ConsumableEvent;
import java.util.Objects;

public final class HttpEventKey<T> {
    public static final HttpEventKey<ConsumableEvent<Integer>> MAX_CONCURRENCY = HttpEventKey.newKey("max-concurrency", HttpEventKey.generify(ConsumableEvent.class));
    private final String name;
    private final Class<T> type;

    private HttpEventKey(String name, Class<T> type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public static <T> HttpEventKey<T> newKey(String name, Class<T> type) {
        return new HttpEventKey<T>(name, type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", type=" + this.type.getSimpleName() + "}@" + Integer.toHexString(this.hashCode());
    }

    private static <T> Class<T> generify(Class<?> clazz) {
        return clazz;
    }
}

