/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.server.ClassPathResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.StyleResource;
import org.apache.baremaps.server.TileJSONResource;
import org.apache.baremaps.server.TileResource;
import org.apache.baremaps.tilestore.TileCache;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.PostgresUtils;
import org.apache.baremaps.vectortile.style.Style;
import org.apache.baremaps.vectortile.tilejson.TileJSON;
import org.apache.baremaps.vectortile.tileset.Tileset;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start a tile server with caching capabilities."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tilesetPath;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path stylePath;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        ConfigReader configReader = new ConfigReader();
        CaffeineSpec caffeineSpec = CaffeineSpec.parse((String)this.cache);
        Tileset tileset = (Tileset)objectMapper.readValue(configReader.read(this.tilesetPath), Tileset.class);
        DataSource datasource = PostgresUtils.createDataSourceFromObject((Object)tileset.getDatabase());
        TypeLiteral<Supplier<TileStore>> tileStoreSupplierType = new TypeLiteral<Supplier<TileStore>>(){};
        PostgresTileStore tileStore = new PostgresTileStore(datasource, tileset);
        TileCache tileCache = new TileCache((TileStore)tileStore, caffeineSpec);
        final Supplier<TileStore> tileStoreSupplier = () -> tileCache;
        TypeLiteral<Supplier<Style>> styleSupplierType = new TypeLiteral<Supplier<Style>>(){};
        Style style = (Style)objectMapper.readValue(configReader.read(this.stylePath), Style.class);
        Supplier<Style> styleSupplier = () -> style;
        TypeLiteral<Supplier<TileJSON>> tileJSONSupplierType = new TypeLiteral<Supplier<TileJSON>>(){};
        TileJSON tileJSON = (TileJSON)objectMapper.readValue(configReader.read(this.tilesetPath), TileJSON.class);
        Supplier<TileJSON> tileJSONSupplier = () -> tileJSON;
        ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(TileResource.class).register(StyleResource.class).register(TileJSONResource.class).register(ClassPathResource.class).register((Object)ServiceTalkJacksonSerializerFeature.newContextResolver((ObjectMapper)objectMapper)).register((Object)new AbstractBinder(tileStoreSupplierType, styleSupplier, styleSupplierType, tileJSONSupplier, tileJSONSupplierType){
            final /* synthetic */ 1 val$tileStoreSupplierType;
            final /* synthetic */ Supplier val$styleSupplier;
            final /* synthetic */ 2 val$styleSupplierType;
            final /* synthetic */ Supplier val$tileJSONSupplier;
            final /* synthetic */ 3 val$tileJSONSupplierType;
            {
                this.val$tileStoreSupplierType = var3_3;
                this.val$styleSupplier = supplier2;
                this.val$styleSupplierType = var5_5;
                this.val$tileJSONSupplier = supplier3;
                this.val$tileJSONSupplierType = var7_7;
            }

            protected void configure() {
                this.bind("assets").to(String.class).named("directory");
                this.bind("server.html").to(String.class).named("index");
                this.bind(tileStoreSupplier).to((TypeLiteral)this.val$tileStoreSupplierType);
                this.bind(this.val$styleSupplier).to((TypeLiteral)this.val$styleSupplierType);
                this.bind(this.val$tileJSONSupplier).to((TypeLiteral)this.val$tileJSONSupplierType);
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

