/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.BackwardDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAFindInnerLiteralStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import java.util.Arrays;

public final class TRegexDFAExecutorNode
extends TRegexExecutorNode {
    private static final int IP_TRANSITION_MARKER = 32768;
    public static final int NO_MATCH = -2;
    private final TRegexDFAExecutorProperties props;
    private final int maxNumberOfNFAStates;
    @Node.Children
    private final DFAAbstractStateNode[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] cgResultOrder;
    private final TRegexDFAExecutorDebugRecorder debugRecorder;

    public TRegexDFAExecutorNode(TRegexDFAExecutorProperties props, int maxNumberOfNFAStates, int numberOfCaptureGroups, DFAAbstractStateNode[] states, TRegexDFAExecutorDebugRecorder debugRecorder) {
        this.props = props;
        this.maxNumberOfNFAStates = maxNumberOfNFAStates;
        this.states = states;
        this.cgResultOrder = props.isGenericCG() && maxNumberOfNFAStates > 1 ? TRegexDFAExecutorNode.initResultOrder(maxNumberOfNFAStates, numberOfCaptureGroups, props) : null;
        this.debugRecorder = debugRecorder;
    }

    private DFAInitialStateNode getInitialState() {
        return (DFAInitialStateNode)this.states[0];
    }

    public int getPrefixLength() {
        return this.getInitialState().getPrefixLength();
    }

    public boolean isAnchored() {
        return !this.getInitialState().hasUnAnchoredEntry();
    }

    @Override
    public boolean isForward() {
        return this.props.isForward();
    }

    public boolean isBackward() {
        return !this.props.isForward();
    }

    public boolean isSearching() {
        return this.props.isSearching();
    }

    public boolean isSimpleCG() {
        return this.props.isSimpleCG();
    }

    public boolean isGenericCG() {
        return this.props.isGenericCG();
    }

    public boolean isRegressionTestMode() {
        return this.props.isRegressionTestMode();
    }

    public int getNumberOfStates() {
        return this.states.length;
    }

    public int getNumberOfTransitions() {
        int sum = 0;
        for (DFAAbstractStateNode state : this.states) {
            sum += state.getSuccessors().length;
            if (!(state instanceof DFAStateNode) || ((DFAStateNode)state).getMatchers().getNoMatchSuccessor() < 0) continue;
            ++sum;
        }
        return sum;
    }

    public boolean recordExecution() {
        return this.debugRecorder != null;
    }

    public TRegexDFAExecutorDebugRecorder getDebugRecorder() {
        return this.debugRecorder;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexDFAExecutorLocals(input, fromIndex, index, maxIndex, this.createCGData());
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.isSimpleCG();
    }

    private DFACaptureGroupTrackingData createCGData() {
        if (this.isSimpleCG()) {
            return new DFACaptureGroupTrackingData(null, TRegexDFAExecutorNode.createResultsArray(this.resultLength()), this.props.isSimpleCGMustCopy() ? new int[this.resultLength()] : null);
        }
        if (this.isGenericCG()) {
            return new DFACaptureGroupTrackingData(this.maxNumberOfNFAStates == 1 ? null : Arrays.copyOf(this.cgResultOrder, this.cgResultOrder.length), TRegexDFAExecutorNode.createResultsArray(this.maxNumberOfNFAStates * this.resultLength()), new int[this.resultLength()]);
        }
        return null;
    }

    private int resultLength() {
        return this.getNumberOfCaptureGroups() * 2 + (this.props.tracksLastGroup() ? 1 : 0);
    }

    private static int[] createResultsArray(int length) {
        int[] results = new int[length];
        Arrays.fill(results, -1);
        return results;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object execute(TRegexExecutorLocals abstractLocals, TruffleString.CodeRange codeRange, boolean tString) {
        block84: {
            locals = (TRegexDFAExecutorLocals)abstractLocals;
            CompilerDirectives.ensureVirtualized((Object)locals);
            CompilerAsserts.partialEvaluationConstant((Object)this.states);
            CompilerAsserts.partialEvaluationConstant((int)this.states.length);
            CompilerAsserts.partialEvaluationConstant((Object)codeRange);
            if (!this.validArgs(locals)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("Got illegal args! (fromIndex %d, initialIndex %d, maxIndex %d)", new Object[]{locals.getFromIndex(), locals.getIndex(), locals.getMaxIndex()}));
            }
            if (this.isGenericCG() || this.isSimpleCG()) {
                CompilerDirectives.ensureVirtualized((Object)locals.getCGData());
            }
            if (this.props.getMinResultLength() > 0 && (this.isForward() != false ? locals.getMaxIndex() - locals.getIndex() : locals.getIndex() - Math.max(0, locals.getFromIndex() - this.getPrefixLength())) < this.props.getMinResultLength()) {
                return this.isGenericCG() != false || this.isSimpleCG() != false ? null : Integer.valueOf(-2);
            }
            if (this.recordExecution()) {
                this.debugRecorder.startRecording(locals);
            }
            if (this.isBackward()) {
                locals.setCurMinIndex(locals.getFromIndex());
            }
            ip = 0;
            block5: while (true) {
                block85: {
                    block87: {
                        block88: {
                            block89: {
                                block86: {
                                    locals.incLoopCount(this);
                                    if (CompilerDirectives.inInterpreter()) {
                                        RegexRootNode.checkThreadInterrupted();
                                    }
                                    CompilerAsserts.partialEvaluationConstant((int)ip);
                                    if (ip < 0) break block84;
                                    curState = this.states[ip & 32767];
                                    CompilerAsserts.partialEvaluationConstant((Object)curState);
                                    successors = curState.getSuccessors();
                                    CompilerAsserts.partialEvaluationConstant((Object)successors);
                                    CompilerAsserts.partialEvaluationConstant((int)successors.length);
                                    if (curState instanceof DFAInitialStateNode) {
                                        if (this.isSearching()) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                                                throw new AssertionError();
                                            }
                                            for (i = 0; i < this.getPrefixLength(); ++i) {
                                                if (locals.getIndex() <= 0) {
                                                    this.initNextIndex(locals);
                                                    ip = this.initialStateSuccessor(locals, curState, successors, i);
                                                    continue block5;
                                                }
                                                this.inputSkipIntl(locals, false);
                                            }
                                            this.initNextIndex(locals);
                                            atBegin = this.inputAtBegin(locals);
                                        } else {
                                            this.initNextIndex(locals);
                                            atBegin = this.inputAtBegin(locals);
                                            for (i = 0; i < this.getPrefixLength(); ++i) {
                                                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                                                    throw new AssertionError();
                                                }
                                                if (locals.getIndex() >= locals.getFromIndex()) {
                                                    if (atBegin) {
                                                        ip = this.initialStateSuccessor(locals, curState, successors, i);
                                                        continue block5;
                                                    }
                                                    ip = this.initialStateSuccessor(locals, curState, successors, i + successors.length / 2);
                                                    continue block5;
                                                }
                                                this.inputSkipIntl(locals, true);
                                            }
                                        }
                                        if (atBegin) {
                                            ip = this.initialStateSuccessor(locals, curState, successors, this.getPrefixLength());
                                            continue;
                                        }
                                        ip = this.initialStateSuccessor(locals, curState, successors, this.getPrefixLength() + successors.length / 2);
                                        continue;
                                    }
                                    if (!(curState instanceof DFAStateNode)) break block85;
                                    state = (DFAStateNode)curState;
                                    if (ip > 32768) {
                                        i = ip >> 16;
                                        ip = this.execTransition(locals, state, i);
                                        continue;
                                    }
                                    this.inputAdvance(locals);
                                    state.beforeFindSuccessor(locals, this);
                                    if (this.isForward() && state.canDoIndexOf() && this.inputHasNext(locals)) {
                                        indexOfResult = state.loopOptimizationNode.execute(locals.getInput(), locals.getIndex(), this.getMaxIndex(locals), this.getEncoding(), tString);
                                        postLoopIndex = indexOfResult < 0 ? this.getMaxIndex(locals) : indexOfResult;
                                        state.afterIndexOf(locals, this, locals.getIndex(), postLoopIndex);
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && locals.getIndex() != postLoopIndex) {
                                            throw new AssertionError();
                                        }
                                        if (successors.length == 2 && indexOfResult >= 0) {
                                            successor = state.getLoopToSelf() + 1 & 1;
                                            CompilerAsserts.partialEvaluationConstant((int)successor);
                                            this.inputIncNextIndexRaw(locals, state.loopOptimizationNode.encodedLength());
                                            ip = this.execTransition(locals, state, successor);
                                            continue;
                                        }
                                    }
                                    if (!this.inputHasNext(locals)) {
                                        state.atEnd(locals, this);
                                        if (this.isBackward() && state.hasBackwardPrefixState() && locals.getIndex() > 0) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && locals.getIndex() != locals.getFromIndex()) {
                                                throw new AssertionError();
                                            }
                                            locals.setCurMinIndex(0);
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, ((BackwardDFAStateNode)state).getBackwardPrefixStateIndex());
                                            continue;
                                        }
                                        break block84;
                                    }
                                    if (state.treeTransitionMatching()) {
                                        c = this.inputReadAndDecode(locals);
                                        treeSuccessor = state.getTreeMatcher().checkMatchTree(c);
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && this.isRegressionTestMode() && !state.sameResultAsRegularMatchers(c, treeSuccessor)) {
                                            throw new AssertionError();
                                        }
                                        for (i = 0; i < successors.length; ++i) {
                                            if (i != treeSuccessor) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                        break block84;
                                    }
                                    matchers = state.getMatchers();
                                    if (!(matchers instanceof Matchers.SimpleMatchers)) break block86;
                                    c = this.inputReadAndDecode(locals);
                                    cMatchers = ((Matchers.SimpleMatchers)matchers).getMatchers();
                                    if (cMatchers != null) {
                                        for (i = 0; i < cMatchers.length; ++i) {
                                            if (!TRegexDFAExecutorNode.match(cMatchers, i, c)) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                    }
                                    break block87;
                                }
                                if (!(matchers instanceof Matchers.UTF8Matchers)) break block88;
                                utf8Matchers = (Matchers.UTF8Matchers)matchers;
                                ascii = utf8Matchers.getAscii();
                                enc2 = utf8Matchers.getEnc2();
                                enc3 = utf8Matchers.getEnc3();
                                enc4 = utf8Matchers.getEnc4();
                                c = this.inputReadRaw(locals);
                                if (codeRange != TruffleString.CodeRange.ASCII && c >= 128) break block89;
                                this.inputIncNextIndexRaw(locals);
                                if (ascii != null) {
                                    for (i = 0; i < ascii.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(ascii, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                                break block87;
                            }
                            this.getBMPProfile().enter();
                            codepoint = c & 63;
                            if (this.isBackward()) {
                                if (!TRegexDFAExecutorNode.$assertionsDisabled && c >> 6 != 2) {
                                    throw new AssertionError();
                                }
                                for (i = 1; i < 4; ++i) {
                                    c = this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() - i);
                                    if (i >= 3 || c >> 6 != 2) break;
                                    codepoint |= (c & 63) << 6 * i;
                                }
                            }
                            nBytes = Integer.numberOfLeadingZeros(~(c << 24));
                            if (!(TRegexDFAExecutorNode.$assertionsDisabled || 1 < nBytes && nBytes < 5)) {
                                throw new AssertionError(nBytes);
                            }
                            this.inputIncNextIndexRaw(locals, nBytes);
                            if (this.isBackward()) {
                                codepoint |= (c & 255 >>> nBytes) << 6 * (nBytes - 1);
                            }
                            switch (nBytes) {
                                case 2: {
                                    if (enc2 == null) break;
                                    codepoint = this.inputUTF8Decode2(locals, c, codepoint);
                                    for (i = 0; i < enc2.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc2, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break block87;
                                }
                                case 3: {
                                    if (enc3 == null) break;
                                    codepoint = this.inputUTF8Decode3(locals, c, codepoint);
                                    for (i = 0; i < enc3.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc3, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break block87;
                                }
                                case 4: {
                                    if (enc4 == null) break;
                                    this.getAstralProfile().enter();
                                    codepoint = this.inputUTF8Decode4(locals, c, codepoint);
                                    for (i = 0; i < enc4.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc4, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break;
                                }
                            }
                            break block87;
                        }
                        if (matchers instanceof Matchers.UTF16RawMatchers) {
                            c = this.inputReadAndDecode(locals);
                            ascii = ((Matchers.UTF16RawMatchers)matchers).getAscii();
                            latin1 = ((Matchers.UTF16RawMatchers)matchers).getLatin1();
                            bmp = ((Matchers.UTF16RawMatchers)matchers).getBmp();
                            if (latin1 != null && (bmp == null || codeRange.isSubsetOf(TruffleString.CodeRange.LATIN_1) || c < 256)) {
                                byteMatchers = TRegexDFAExecutorNode.asciiOrLatin1Matchers(codeRange, ascii, latin1);
                                for (i = 0; i < byteMatchers.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(byteMatchers, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            } else if (bmp != null) {
                                this.getBMPProfile().enter();
                                for (i = 0; i < bmp.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            }
                        } else {
                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !(matchers instanceof Matchers.UTF16Or32Matchers)) {
                                throw new AssertionError();
                            }
                            utf16Or32Matchers = (Matchers.UTF16Or32Matchers)matchers;
                            ascii = utf16Or32Matchers.getAscii();
                            latin1 = utf16Or32Matchers.getLatin1();
                            bmp = utf16Or32Matchers.getBmp();
                            astral = utf16Or32Matchers.getAstral();
                            c = this.inputReadRaw(locals);
                            this.inputIncNextIndexRaw(locals);
                            if (this.isUTF16()) {
                                if (codeRange.isSupersetOf(TruffleString.CodeRange.VALID) && state.utf16MustDecode() && this.inputUTF16IsHighSurrogate(c) && (codeRange == TruffleString.CodeRange.VALID || this.inputHasNext((TRegexExecutorLocals)locals, locals.getNextIndex()))) {
                                    this.getAstralProfile().enter();
                                    c2 = this.inputReadRaw((TRegexExecutorLocals)locals, locals.getNextIndex());
                                    if (codeRange == TruffleString.CodeRange.VALID || this.inputUTF16IsLowSurrogate(c2)) {
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.inputUTF16IsLowSurrogate(c2)) {
                                            throw new AssertionError();
                                        }
                                        locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                                        if (astral != null) {
                                            c = this.inputUTF16ToCodePoint(c, c2);
                                        }
                                    }
                                    if (astral != null) {
                                        for (i = 0; i < astral.length; ++i) {
                                            if (!TRegexDFAExecutorNode.match(astral, i, c)) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                    }
                                } else if (latin1 != null && (bmp == null || codeRange.isSubsetOf(TruffleString.CodeRange.LATIN_1) || c < 256)) {
                                    byteMatchers = TRegexDFAExecutorNode.asciiOrLatin1Matchers(codeRange, ascii, latin1);
                                    for (i = 0; i < byteMatchers.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(byteMatchers, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                } else if (bmp != null && codeRange.isSupersetOf(TruffleString.CodeRange.BMP)) {
                                    this.getBMPProfile().enter();
                                    for (i = 0; i < bmp.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                            } else {
                                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isUTF32()) {
                                    throw new AssertionError();
                                }
                                if (latin1 != null && (codeRange.isSubsetOf(TruffleString.CodeRange.LATIN_1) || c < 256)) {
                                    byteMatchers = TRegexDFAExecutorNode.asciiOrLatin1Matchers(codeRange, ascii, latin1);
                                    for (i = 0; i < byteMatchers.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(byteMatchers, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                } else if (!(bmp == null || codeRange != TruffleString.CodeRange.BMP && (c > 65535 || codeRange != TruffleString.CodeRange.VALID && Character.isSurrogate((char)c)))) {
                                    this.getBMPProfile().enter();
                                    for (i = 0; i < bmp.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                } else if (astral != null && codeRange.isSupersetOf(TruffleString.CodeRange.VALID)) {
                                    this.getAstralProfile().enter();
                                    for (i = 0; i < astral.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(astral, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                            }
                        }
                    }
                    ip = TRegexDFAExecutorNode.transitionNoMatch(state);
                    continue;
                }
                if (!TRegexDFAExecutorNode.$assertionsDisabled && !(curState instanceof DFAFindInnerLiteralStateNode)) {
                    throw new AssertionError();
                }
                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                    throw new AssertionError();
                }
                state = (DFAFindInnerLiteralStateNode)curState;
lbl265:
                // 2 sources

                while (this.inputHasNext(locals)) {
                    locals.setIndex(state.executeInnerLiteralSearch(locals, this, tString));
                    if (locals.getIndex() >= 0) {
                        if (state.hasPrefixMatcher() && !state.prefixMatcherMatches(locals, codeRange, tString)) break block5;
                        if (!state.hasPrefixMatcher() && this.isSimpleCG()) {
                            locals.getCGData().results[0] = locals.getIndex();
                        }
                        this.inputIncRaw((TRegexExecutorLocals)locals, state.getInnerLiteral().getLiteral().encodedLength());
                        locals.setNextIndex(locals.getIndex());
                        ip = successors[0];
                        continue block5;
                    }
                    break block84;
                }
                break block84;
                break;
            }
            this.inputIncRaw(locals);
            ** GOTO lbl265
        }
        if (this.recordExecution()) {
            this.debugRecorder.finishRecording();
        }
        if (this.isSimpleCG()) {
            result = this.props.isSimpleCGMustCopy() != false ? locals.getCGData().currentResult : locals.getCGData().results;
            return (int[])(locals.getResultInt() == 0 ? result : null);
        }
        if (this.isGenericCG()) {
            return locals.getResultInt() == 0 ? locals.getCGData().currentResult : null;
        }
        return locals.getResultInt();
    }

    private static CharMatcher[] asciiOrLatin1Matchers(TruffleString.CodeRange codeRange, CharMatcher[] ascii, CharMatcher[] latin1) {
        return codeRange == TruffleString.CodeRange.ASCII && ascii != null ? ascii : latin1;
    }

    private short initialStateSuccessor(TRegexDFAExecutorLocals locals, DFAAbstractStateNode curState, short[] successors, int i) {
        if (this.isGenericCG()) {
            locals.setLastIndex();
            short lastTransition = ((DFAInitialStateNode)curState).getCgLastTransition()[i];
            if (lastTransition >= 0) {
                locals.setLastTransition(lastTransition);
            }
        }
        return successors[i];
    }

    private void initNextIndex(TRegexDFAExecutorLocals locals) {
        locals.setNextIndex(locals.getIndex());
        if (this.recordExecution()) {
            this.getDebugRecorder().setInitialIndex(locals.getIndex());
        }
    }

    private static boolean match(CharMatcher[] matchers, int i, int c) {
        return matchers[i] != null && matchers[i].match(c);
    }

    private static int transitionMatch(DFAStateNode state, int i) {
        CompilerAsserts.partialEvaluationConstant((Object)state);
        return state.getId() | 0x8000 | i << 16;
    }

    private static int transitionNoMatch(DFAStateNode state) {
        CompilerAsserts.partialEvaluationConstant((Object)state);
        return state.getId() | 0x8000 | state.getMatchers().getNoMatchSuccessor() << 16;
    }

    private int execTransition(TRegexDFAExecutorLocals locals, DFAStateNode state, int i) {
        CompilerAsserts.partialEvaluationConstant((Object)state);
        CompilerAsserts.partialEvaluationConstant((int)i);
        if (this.recordExecution()) {
            this.debugRecorder.recordTransition(locals.getIndex(), state.getId(), i);
        }
        state.successorFound(locals, this, i);
        return state.successors[i];
    }

    private int inputUTF8Decode2(TRegexDFAExecutorLocals locals, int c, int codepoint) {
        if (this.isForward()) {
            return (c & 0x3F) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 1) & 0x3F;
        }
        return codepoint;
    }

    private int inputUTF8Decode3(TRegexDFAExecutorLocals locals, int c, int codepoint) {
        if (this.isForward()) {
            return (c & 0x1F) << 12 | (this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 1) & 0x3F) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 2) & 0x3F;
        }
        return codepoint;
    }

    private int inputUTF8Decode4(TRegexDFAExecutorLocals locals, int c, int codepoint) {
        if (this.isForward()) {
            return (c & 0xF) << 18 | (this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 1) & 0x3F) << 12 | (this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 2) & 0x3F) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 3) & 0x3F;
        }
        return codepoint;
    }

    @Override
    public int getMinIndex(TRegexExecutorLocals locals) {
        return this.isForward() ? super.getMinIndex(locals) : ((TRegexDFAExecutorLocals)locals).getCurMinIndex();
    }

    private boolean validArgs(TRegexDFAExecutorLocals locals) {
        int initialIndex = locals.getIndex();
        int inputLength = this.getInputLength(locals);
        int fromIndex = locals.getFromIndex();
        int maxIndex = locals.getMaxIndex();
        return inputLength >= 0 && inputLength < 2147483627 && fromIndex >= 0 && fromIndex <= inputLength && initialIndex >= 0 && initialIndex <= maxIndex && maxIndex >= fromIndex && maxIndex <= inputLength;
    }

    private static int[] initResultOrder(int maxNumberOfNFAStates, int numberOfCaptureGroups, TRegexDFAExecutorProperties props) {
        int[] resultOrder = new int[maxNumberOfNFAStates];
        for (int i = 0; i < maxNumberOfNFAStates; ++i) {
            resultOrder[i] = i * (numberOfCaptureGroups * 2 + (props.tracksLastGroup() ? 1 : 0));
        }
        return resultOrder;
    }

    public TRegexDFAExecutorProperties getProperties() {
        return this.props;
    }

    public int getMaxNumberOfNFAStates() {
        return this.maxNumberOfNFAStates;
    }
}

