/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class DFAFindInnerLiteralStateNode
extends DFAAbstractStateNode {
    private final InnerLiteral innerLiteral;
    @Node.Child
    private InputIndexOfStringNode indexOfNode = InputIndexOfStringNode.create();
    @Node.Child
    private TRegexDFAExecutorNode prefixMatcher;

    public DFAFindInnerLiteralStateNode(short id, short[] successors, InnerLiteral innerLiteral, TRegexDFAExecutorNode prefixMatcher) {
        super(id, successors);
        assert (successors.length == 1);
        this.innerLiteral = innerLiteral;
        this.prefixMatcher = prefixMatcher;
    }

    public InnerLiteral getInnerLiteral() {
        return this.innerLiteral;
    }

    @Override
    public DFAAbstractStateNode createNodeSplitCopy(short copyID) {
        return new DFAFindInnerLiteralStateNode(copyID, Arrays.copyOf(this.getSuccessors(), this.getSuccessors().length), this.innerLiteral, this.prefixMatcher);
    }

    public boolean hasPrefixMatcher() {
        return this.prefixMatcher != null;
    }

    int executeInnerLiteralSearch(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean tString) {
        return this.indexOfNode.execute(locals.getInput(), locals.getIndex(), executor.getMaxIndex(locals), this.innerLiteral.getLiteralContent(tString), this.innerLiteral.getMaskContent(tString), executor.getEncoding());
    }

    boolean prefixMatcherMatches(TRegexDFAExecutorLocals locals, TruffleString.CodeRange codeRange, boolean tString) {
        Object result = this.prefixMatcher.execute(locals.toInnerLiteralBackwardLocals(), codeRange, tString);
        return this.prefixMatcher.isSimpleCG() ? result != null : (Integer)result != -2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("anchoredFinalState", false), Json.prop("finalState", false), Json.prop("loopToSelf", false), Json.prop("transitions", Json.array(Json.obj(Json.prop("matcher", "innerLiteral(" + this.innerLiteral.getLiteral() + ")"), Json.prop("target", this.successors[0])))));
    }
}

