/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record DownloadUrl(String url, Path path, boolean replaceExisting) implements Task
{
    private static final String PROTOCOL_FTP = "ftp";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final Logger logger = LoggerFactory.getLogger(DownloadUrl.class);

    public DownloadUrl(String url, Path path) {
        this(url, path, false);
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        URL targetUrl = new URL(this.url);
        Path targetPath = this.path.toAbsolutePath();
        if (Files.exists(targetPath, new LinkOption[0]) && !this.replaceExisting) {
            logger.info("Skipping download of {} to {}", (Object)this.url, (Object)this.path);
            return;
        }
        if (DownloadUrl.isHttp(targetUrl)) {
            HttpURLConnection get = (HttpURLConnection)targetUrl.openConnection();
            get.setInstanceFollowRedirects(true);
            get.setRequestMethod("GET");
            DownloadUrl.urlDownloadToFile(get, targetPath);
            get.disconnect();
        } else if (DownloadUrl.isFtp(targetUrl)) {
            DownloadUrl.urlDownloadToFile(targetUrl.openConnection(), targetPath);
        } else {
            throw new IllegalArgumentException("Unsupported URL protocol (supported: http(s)/ftp)");
        }
    }

    private static boolean isHttp(URL url) {
        return url.getProtocol().equalsIgnoreCase(PROTOCOL_HTTP) || url.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS);
    }

    private static boolean isFtp(URL url) {
        return url.getProtocol().equalsIgnoreCase(PROTOCOL_FTP);
    }

    private static void urlDownloadToFile(URLConnection url, Path targetPath) throws IOException {
        try (InputStream inputStream = url.getInputStream();){
            Files.createDirectories(targetPath.toAbsolutePath().getParent(), new FileAttribute[0]);
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

