/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.iploc.IpLocObject;
import org.apache.baremaps.iploc.IpLocReader;
import org.apache.baremaps.iploc.IpLocRepository;
import org.apache.baremaps.stream.StreamException;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

public record CreateIplocIndex(Path geonamesIndexPath, List<Path> nicPaths, Path targetIplocIndexPath) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(CreateIplocIndex.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        try (FSDirectory directory = MMapDirectory.open((Path)this.geonamesIndexPath);
             SearcherManager searcherManager = new SearcherManager((Directory)directory, new SearcherFactory());){
            logger.info("Creating the Iploc database");
            String jdbcUrl = String.format("JDBC:sqlite:%s", this.targetIplocIndexPath);
            SQLiteConfig config = new SQLiteConfig();
            SQLiteDataSource dataSource = new SQLiteDataSource(config);
            dataSource.setUrl(jdbcUrl);
            IpLocRepository ipLocRepository = new IpLocRepository((DataSource)dataSource);
            ipLocRepository.dropTable();
            ipLocRepository.createTable();
            ipLocRepository.createIndex();
            IpLocReader ipLocReader = new IpLocReader(searcherManager);
            this.nicPaths.parallelStream().forEach(path -> {
                try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    Stream<IpLocObject> ipLocStream = ipLocReader.read(inputStream);
                    ipLocRepository.save(ipLocStream);
                }
                catch (IOException e) {
                    throw new StreamException(e);
                }
            });
        }
    }
}

