/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.vectortile;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.baremaps.mvt.binary.VectorTile;
import org.apache.baremaps.vectortile.Feature;
import org.apache.baremaps.vectortile.Layer;
import org.apache.baremaps.vectortile.Tile;
import org.apache.baremaps.vectortile.VectorTileFunctions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class VectorTileDecoder {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private int cx = 0;
    private int cy = 0;
    private List<String> keys = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();

    public Tile decodeTile(ByteBuffer buffer) throws IOException {
        try {
            VectorTile.Tile tile = VectorTile.Tile.parseFrom(buffer);
            return this.decodeTile(tile);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException(e);
        }
    }

    public Tile decodeTile(VectorTile.Tile tile) {
        List<Layer> layers = tile.getLayersList().stream().map(this::decodeLayer).collect(Collectors.toList());
        return new Tile(layers);
    }

    public Layer decodeLayer(ByteBuffer buffer) throws IOException {
        try {
            VectorTile.Tile.Layer layer = VectorTile.Tile.Layer.parseFrom(buffer);
            return this.decodeLayer(layer);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException(e);
        }
    }

    public Layer decodeLayer(VectorTile.Tile.Layer layer) {
        String name = layer.getName();
        int extent = layer.getExtent();
        this.cx = 0;
        this.cy = 0;
        this.keys = layer.getKeysList();
        this.values = layer.getValuesList().stream().map(this::decodeValue).collect(Collectors.toList());
        List<Feature> features = layer.getFeaturesList().stream().map(this::decodeFeature).collect(Collectors.toList());
        return new Layer(name, extent, features);
    }

    protected Object decodeValue(VectorTile.Tile.Value value) {
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        if (value.hasFloatValue()) {
            return Float.valueOf(value.getFloatValue());
        }
        if (value.hasDoubleValue()) {
            return value.getDoubleValue();
        }
        if (value.hasIntValue()) {
            return value.getIntValue();
        }
        if (value.hasSintValue()) {
            return value.getSintValue();
        }
        if (value.hasUintValue()) {
            return value.getUintValue();
        }
        if (value.hasBoolValue()) {
            return value.getBoolValue();
        }
        throw new IllegalStateException("Value is not set.");
    }

    protected Feature decodeFeature(VectorTile.Tile.Feature feature) {
        this.cx = 0;
        this.cy = 0;
        long id = feature.getId();
        Map<String, Object> tags = this.decodeTags(feature);
        Geometry geometry = this.decodeGeometry(feature);
        return new Feature(id, tags, geometry);
    }

    protected Map<String, Object> decodeTags(VectorTile.Tile.Feature feature) {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        List<Integer> encoding = feature.getTagsList();
        for (int i = 0; i < encoding.size(); i += 2) {
            int key = encoding.get(i);
            int value = encoding.get(i + 1);
            tags.put(this.keys.get(key), this.values.get(value));
        }
        return tags;
    }

    protected Geometry decodeGeometry(VectorTile.Tile.Feature feature) {
        VectorTile.Tile.GeomType type = feature.getType();
        List<Integer> encoding = feature.getGeometryList();
        switch (type) {
            case POINT: {
                return this.decodePoint(encoding);
            }
            case LINESTRING: {
                return this.decodeLineString(encoding);
            }
            case POLYGON: {
                return this.decodePolygon(encoding);
            }
        }
        throw new IllegalStateException("Unknown geometry type.");
    }

    protected Geometry decodePoint(List<Integer> encoding) {
        int length;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < encoding.size(); i += length) {
            int value = encoding.get(i);
            int command = this.command(value);
            int count = this.count(value);
            ++i;
            length = count * 2;
            for (int j = 0; j < length; j += 2) {
                this.cx += this.parameter(encoding.get(i + j)).intValue();
                this.cy += this.parameter(encoding.get(i + j + 1)).intValue();
                if (command != 1) continue;
                coordinates.add(new Coordinate((double)this.cx, (double)this.cy));
            }
        }
        if (coordinates.size() == 1) {
            return GEOMETRY_FACTORY.createPoint((Coordinate)coordinates.get(0));
        }
        if (coordinates.size() > 1) {
            return GEOMETRY_FACTORY.createMultiPointFromCoords(coordinates.toArray(new Coordinate[0]));
        }
        throw new IllegalStateException("No coordinates found.");
    }

    protected Geometry decodeLineString(List<Integer> encoding) {
        int length;
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < encoding.size(); i += length) {
            int value = encoding.get(i);
            int command = this.command(value);
            int count = this.count(value);
            ++i;
            length = count * 2;
            for (int j = 0; j < length; j += 2) {
                this.cx += this.parameter(encoding.get(i + j)).intValue();
                this.cy += this.parameter(encoding.get(i + j + 1)).intValue();
                if (command == 1) {
                    coordinates.clear();
                    coordinates.add(new Coordinate((double)this.cx, (double)this.cy));
                    continue;
                }
                if (command != 2) continue;
                coordinates.add(new Coordinate((double)this.cx, (double)this.cy));
            }
            if (coordinates.size() <= 1) continue;
            lineStrings.add(GEOMETRY_FACTORY.createLineString(coordinates.toArray(new Coordinate[0])));
        }
        if (lineStrings.size() == 1) {
            return (Geometry)lineStrings.get(0);
        }
        if (lineStrings.size() > 1) {
            return GEOMETRY_FACTORY.createMultiLineString(lineStrings.toArray(new LineString[0]));
        }
        throw new IllegalStateException("No linestrings found.");
    }

    protected Geometry decodePolygon(List<Integer> encoding) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Optional<Object> shell = Optional.empty();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        int i = 0;
        while (i < encoding.size()) {
            int value = encoding.get(i);
            int command = this.command(value);
            int count = this.count(value);
            if (command == 1 || command == 2) {
                ++i;
                int length = count * 2;
                for (int j = 0; j < length; j += 2) {
                    this.cx += this.parameter(encoding.get(i + j)).intValue();
                    this.cy += this.parameter(encoding.get(i + j + 1)).intValue();
                    if (command == 1) {
                        coordinates.clear();
                        coordinates.add(new Coordinate((double)this.cx, (double)this.cy));
                        continue;
                    }
                    if (command != 2) continue;
                    coordinates.add(new Coordinate((double)this.cx, (double)this.cy));
                }
                i += length;
            }
            if (command != 7) continue;
            coordinates.add((Coordinate)coordinates.get(0));
            LinearRing linearRing = GEOMETRY_FACTORY.createLinearRing(coordinates.toArray(new Coordinate[0]));
            boolean isShell = VectorTileFunctions.isClockWise((Geometry)linearRing);
            if (isShell && shell.isPresent()) {
                polygons.add(GEOMETRY_FACTORY.createPolygon((LinearRing)shell.get(), holes.toArray(new LinearRing[0])));
                holes.clear();
            }
            if (isShell) {
                shell = Optional.of(linearRing);
            } else {
                holes.add(linearRing);
            }
            coordinates.clear();
            ++i;
        }
        if (shell.isPresent()) {
            polygons.add(GEOMETRY_FACTORY.createPolygon((LinearRing)shell.get(), holes.toArray(new LinearRing[0])));
            holes.clear();
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        if (polygons.size() > 1) {
            return GEOMETRY_FACTORY.createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        throw new IllegalStateException("No polygons found.");
    }

    protected int command(int value) {
        return value & 7;
    }

    protected int count(int value) {
        return value >> 3;
    }

    protected Integer parameter(int value) {
        return value >> 1 ^ -(value & 1);
    }
}

