/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataColumnImpl;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowImpl;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.database.schema.DataRowTypeImpl;
import org.locationtech.jts.geom.Geometry;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.GeometryConversions;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.generated.Column;
import org.wololo.flatgeobuf.generated.Crs;
import org.wololo.flatgeobuf.generated.Feature;
import org.wololo.flatgeobuf.generated.Header;

public class FlatGeoBufTypeConversion {
    public static final EnumMap<DataColumn.Type, Integer> types = new EnumMap(DataColumn.Type.class);

    public static DataRowType asRowType(HeaderMeta headerMeta) {
        String name = headerMeta.name;
        List<DataColumn> columns = headerMeta.columns.stream().map(column -> new DataColumnImpl(column.name, DataColumn.Type.fromBinding(column.getBinding()))).map(DataColumn.class::cast).toList();
        return new DataRowTypeImpl(name, columns);
    }

    public static DataRow asRow(HeaderMeta headerMeta, DataRowType dataType, Feature feature) {
        ArrayList<Object> values = new ArrayList<Object>();
        org.wololo.flatgeobuf.generated.Geometry geometryBuffer = feature.geometry();
        Geometry geometry = GeometryConversions.deserialize((org.wololo.flatgeobuf.generated.Geometry)geometryBuffer, (int)geometryBuffer.type());
        values.add(geometry);
        if (feature.propertiesLength() > 0) {
            ByteBuffer propertiesBuffer = feature.propertiesAsByteBuffer();
            while (propertiesBuffer.hasRemaining()) {
                short type = propertiesBuffer.getShort();
                ColumnMeta column = (ColumnMeta)headerMeta.columns.get(type);
                Object value = FlatGeoBufTypeConversion.readValue(propertiesBuffer, column);
                values.add(value);
            }
        }
        return new DataRowImpl(dataType, values);
    }

    public static void writeHeaderMeta(HeaderMeta headerMeta, WritableByteChannel channel, FlatBufferBuilder builder) throws IOException {
        int[] columnsArray = headerMeta.columns.stream().mapToInt(c -> {
            int nameOffset = builder.createString((CharSequence)c.name);
            byte type = c.type;
            return Column.createColumn((FlatBufferBuilder)builder, (int)nameOffset, (int)type, (int)0, (int)0, (int)c.width, (int)c.precision, (int)c.scale, (boolean)c.nullable, (boolean)c.unique, (boolean)c.primary_key, (int)0);
        }).toArray();
        int columnsOffset = Header.createColumnsVector((FlatBufferBuilder)builder, (int[])columnsArray);
        int nameOffset = 0;
        if (headerMeta.name != null) {
            nameOffset = builder.createString((CharSequence)headerMeta.name);
        }
        int crsOffset = 0;
        if (headerMeta.srid != 0) {
            Crs.startCrs((FlatBufferBuilder)builder);
            Crs.addCode((FlatBufferBuilder)builder, (int)headerMeta.srid);
            crsOffset = Crs.endCrs((FlatBufferBuilder)builder);
        }
        int envelopeOffset = 0;
        if (headerMeta.envelope != null) {
            envelopeOffset = Header.createEnvelopeVector((FlatBufferBuilder)builder, (double[])new double[]{headerMeta.envelope.getMinX(), headerMeta.envelope.getMinY(), headerMeta.envelope.getMaxX(), headerMeta.envelope.getMaxY()});
        }
        Header.startHeader((FlatBufferBuilder)builder);
        Header.addGeometryType((FlatBufferBuilder)builder, (int)headerMeta.geometryType);
        Header.addIndexNodeSize((FlatBufferBuilder)builder, (int)headerMeta.indexNodeSize);
        Header.addColumns((FlatBufferBuilder)builder, (int)columnsOffset);
        Header.addEnvelope((FlatBufferBuilder)builder, (int)envelopeOffset);
        Header.addName((FlatBufferBuilder)builder, (int)nameOffset);
        Header.addCrs((FlatBufferBuilder)builder, (int)crsOffset);
        Header.addFeaturesCount((FlatBufferBuilder)builder, (long)headerMeta.featuresCount);
        int offset = Header.endHeader((FlatBufferBuilder)builder);
        builder.finishSizePrefixed(offset);
        ByteBuffer dataBuffer = builder.dataBuffer();
        while (dataBuffer.hasRemaining()) {
            channel.write(dataBuffer);
        }
    }

    public static Object readValue(ByteBuffer propertiesBuffer, ColumnMeta column) {
        return switch (column.type) {
            case 0 -> propertiesBuffer.get();
            case 2 -> propertiesBuffer.get() == 1;
            case 3 -> propertiesBuffer.getShort();
            case 5 -> propertiesBuffer.getInt();
            case 7 -> propertiesBuffer.getLong();
            case 9 -> Float.valueOf(propertiesBuffer.getFloat());
            case 10 -> propertiesBuffer.getDouble();
            case 11 -> FlatGeoBufTypeConversion.readString(propertiesBuffer);
            case 12 -> FlatGeoBufTypeConversion.readJson(propertiesBuffer);
            case 13 -> FlatGeoBufTypeConversion.readDateTime(propertiesBuffer);
            case 14 -> FlatGeoBufTypeConversion.readBinary(propertiesBuffer);
            default -> null;
        };
    }

    public static void writeValue(ByteBuffer propertiesBuffer, ColumnMeta column, Object value) {
        switch (column.type) {
            case 0: {
                propertiesBuffer.put((Byte)value);
                break;
            }
            case 2: {
                propertiesBuffer.put((byte)((Boolean)value != false ? 1 : 0));
                break;
            }
            case 3: {
                propertiesBuffer.putShort((Short)value);
                break;
            }
            case 5: {
                propertiesBuffer.putInt((Integer)value);
                break;
            }
            case 7: {
                propertiesBuffer.putLong((Long)value);
                break;
            }
            case 9: {
                propertiesBuffer.putFloat(((Float)value).floatValue());
                break;
            }
            case 10: {
                propertiesBuffer.putDouble((Double)value);
                break;
            }
            case 11: {
                FlatGeoBufTypeConversion.writeString(propertiesBuffer, value);
                break;
            }
            case 12: {
                FlatGeoBufTypeConversion.writeJson(propertiesBuffer, value);
                break;
            }
            case 13: {
                FlatGeoBufTypeConversion.writeDateTime(propertiesBuffer, value);
                break;
            }
            case 14: {
                FlatGeoBufTypeConversion.writeBinary(propertiesBuffer, value);
                break;
            }
        }
    }

    public static void writeString(ByteBuffer propertiesBuffer, Object value) {
        byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
        propertiesBuffer.putInt(bytes.length);
        propertiesBuffer.put(bytes);
    }

    public static void writeJson(ByteBuffer propertiesBuffer, Object value) {
        throw new UnsupportedOperationException();
    }

    public static void writeDateTime(ByteBuffer propertiesBuffer, Object value) {
        throw new UnsupportedOperationException();
    }

    public static void writeBinary(ByteBuffer propertiesBuffer, Object value) {
        throw new UnsupportedOperationException();
    }

    public static Object readString(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static Object readJson(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public static Object readDateTime(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public static Object readBinary(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public static List<ColumnMeta> asColumns(List<DataColumn> columns) {
        return columns.stream().map(FlatGeoBufTypeConversion::asColumn).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static ColumnMeta asColumn(DataColumn column) {
        Integer type = types.get((Object)column.type());
        if (type == null) {
            return null;
        }
        ColumnMeta columnMeta = new ColumnMeta();
        columnMeta.name = column.name();
        columnMeta.type = type.byteValue();
        return columnMeta;
    }

    static {
        types.put(DataColumn.Type.BYTE, 0);
        types.put(DataColumn.Type.BOOLEAN, 2);
        types.put(DataColumn.Type.SHORT, 3);
        types.put(DataColumn.Type.INTEGER, 5);
        types.put(DataColumn.Type.LONG, 7);
        types.put(DataColumn.Type.FLOAT, 9);
        types.put(DataColumn.Type.DOUBLE, 10);
        types.put(DataColumn.Type.STRING, 11);
    }
}

