/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ripe.ipresource.IpResourceRange;
import org.apache.baremaps.geocoder.GeonamesQueryBuilder;
import org.apache.baremaps.iploc.InetRange;
import org.apache.baremaps.iploc.IpLocObject;
import org.apache.baremaps.iploc.IpLocPrecision;
import org.apache.baremaps.iploc.NicAttribute;
import org.apache.baremaps.iploc.NicObject;
import org.apache.baremaps.iploc.NicUtils;
import org.apache.baremaps.utils.IsoCountriesUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpLocMapper
implements Function<NicObject, Optional<IpLocObject>> {
    private static final Logger logger = LoggerFactory.getLogger(IpLocMapper.class);
    private final float SCORE_THRESHOLD = 0.1f;
    private final SearcherManager searcherManager;

    public IpLocMapper(SearcherManager searcherManager) {
        this.searcherManager = searcherManager;
    }

    @Override
    public Optional<IpLocObject> apply(NicObject nicObject) {
        try {
            Optional<Coordinate> location;
            Optional<Coordinate> location2;
            if (nicObject.attributes().isEmpty()) {
                return Optional.empty();
            }
            if (!NicUtils.isInetnum(nicObject)) {
                return Optional.empty();
            }
            NicAttribute inetnum = nicObject.attributes().get(0);
            IpResourceRange ipRange = IpResourceRange.parse((String)inetnum.value());
            InetAddress start = InetAddresses.forString((String)ipRange.getStart().toString());
            InetAddress end = InetAddresses.forString((String)ipRange.getEnd().toString());
            InetRange inetRange = new InetRange(start, end);
            Map<String, String> attributes = nicObject.toMap();
            String network = attributes.getOrDefault("netname", "unknown");
            if (attributes.containsKey("geoloc") && (location2 = this.stringToCoordinate(attributes.get("geoloc"))).isPresent()) {
                return Optional.of(new IpLocObject(attributes.get("geoloc"), inetRange, location2.get(), network, attributes.get("country"), attributes.get("source"), IpLocPrecision.GEOLOC));
            }
            List<String> searchedFields = List.of("descr", "netname");
            if (attributes.keySet().stream().anyMatch(searchedFields::contains) && attributes.containsKey("country")) {
                StringBuilder queryTextBuilder = new StringBuilder();
                for (String field : searchedFields) {
                    if (Strings.isNullOrEmpty((String)attributes.get(field))) continue;
                    queryTextBuilder.append(attributes.get(field)).append(" ");
                }
                String queryText = queryTextBuilder.toString();
                Optional<Coordinate> location3 = this.findLocationInCountry(queryText, attributes.get("country"));
                if (location3.isPresent()) {
                    return Optional.of(new IpLocObject(queryText, inetRange, location3.get(), network, attributes.get("country"), attributes.get("source"), IpLocPrecision.GEOCODER));
                }
            }
            if (attributes.containsKey("country") && (location = this.findCountryLocation(attributes.get("country"))).isPresent()) {
                return Optional.of(new IpLocObject(attributes.get("country"), inetRange, location.get(), network, attributes.get("country"), attributes.get("source"), IpLocPrecision.COUNTRY));
            }
            return Optional.of(new IpLocObject(null, inetRange, new Coordinate(), network, null, attributes.get("source"), IpLocPrecision.WORLD));
        }
        catch (Exception e) {
            logger.warn("Error while mapping nic object to ip loc object", (Throwable)e);
            logger.warn("Nic object attributes:");
            nicObject.attributes().forEach(attribute -> {
                String name = attribute.name();
                String value = attribute.value();
                if (value.length() > 100) {
                    value = value.substring(0, 100).concat("...");
                }
                logger.warn("  {} = {}", (Object)name, (Object)value);
            });
            return Optional.empty();
        }
    }

    private Optional<Coordinate> findCountryLocation(String country) throws IOException, ParseException {
        GeonamesQueryBuilder geonamesQuery = new GeonamesQueryBuilder().featureCode("PCLI");
        if (IsoCountriesUtils.containsCountry(country.toUpperCase())) {
            geonamesQuery.countryCode(country.toUpperCase());
        } else {
            geonamesQuery.queryText(country).build();
        }
        return this.findLocation(geonamesQuery.build());
    }

    private Optional<Coordinate> findLocationInCountry(String terms, String countryCode) throws IOException, ParseException {
        Query geonamesQuery = new GeonamesQueryBuilder().queryText(terms).countryCode(countryCode).build();
        return this.findLocation(geonamesQuery);
    }

    private Optional<Coordinate> findLocation(Query query) throws IOException {
        IndexSearcher indexSearcher = (IndexSearcher)this.searcherManager.acquire();
        TopDocs topDocs = indexSearcher.search(query, 1);
        if (topDocs.scoreDocs.length == 0) {
            return Optional.empty();
        }
        ScoreDoc scoreDoc = topDocs.scoreDocs[0];
        if (scoreDoc.score < 0.1f) {
            return Optional.empty();
        }
        Document document = indexSearcher.doc(scoreDoc.doc);
        double longitude = document.getField("longitude").numericValue().doubleValue();
        double latitude = document.getField("latitude").numericValue().doubleValue();
        return Optional.of(new Coordinate(longitude, latitude));
    }

    private Optional<Coordinate> stringToCoordinate(String geoloc) {
        String doubleRegex = "(\\d+\\.\\d+)";
        Pattern pattern = Pattern.compile("^" + doubleRegex + " " + doubleRegex + "$");
        Matcher matcher = pattern.matcher(geoloc);
        if (matcher.find()) {
            double latitude = Double.parseDouble(matcher.group(1));
            double longitude = Double.parseDouble(matcher.group(2));
            return Optional.of(new Coordinate(longitude, latitude));
        }
        return Optional.empty();
    }
}

