/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;

public class LongArrayDataType
implements DataType<long[]> {
    @Override
    public int size(long[] values) {
        return 4 + values.length * 8;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, long[] values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (long value : values) {
            buffer.putLong(p, value);
            p += 8;
        }
    }

    @Override
    public long[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 8;
        long[] values = new long[length];
        for (int index = 0; index < length; ++index) {
            values[index] = buffer.getLong(position + 4 + index * 8);
        }
        return values;
    }
}

