/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.collection;

import com.google.common.collect.Streams;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DataMap<K, V>
implements Map<K, V> {
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    public List<V> getAll(List<K> keys) {
        return Streams.stream(keys).map(this::get).toList();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract long sizeAsLong();

    @Override
    public int size() {
        return (int)Math.min(this.sizeAsLong(), Integer.MAX_VALUE);
    }

    protected abstract Iterator<K> keyIterator();

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    protected abstract Iterator<V> valueIterator();

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    protected abstract Iterator<Map.Entry<K, V>> entryIterator();

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return DataMap.this.keyIterator();
        }

        @Override
        public int size() {
            return DataMap.this.size();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return DataMap.this.valueIterator();
        }

        @Override
        public int size() {
            return DataMap.this.size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return DataMap.this.entryIterator();
        }

        @Override
        public int size() {
            return DataMap.this.size();
        }
    }
}

