/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.GeoJSONFeatureGeometry;
import org.apache.baremaps.ogcapi.model.GeoJSONFeatureId;

@JsonTypeName(value="GeoJSON_Feature")
public class GeoJSONFeature {
    @Valid
    private TypeEnum type;
    @Valid
    private GeoJSONFeatureId id;
    @Valid
    private Object properties;
    @Valid
    private GeoJSONFeatureGeometry geometry;
    @Valid
    private List<BigDecimal> bbox = null;

    public GeoJSONFeature type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public GeoJSONFeature id(GeoJSONFeatureId id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="id")
    public GeoJSONFeatureId getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(GeoJSONFeatureId id) {
        this.id = id;
    }

    public GeoJSONFeature properties(Object properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="properties")
    @NotNull
    public Object getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public GeoJSONFeature geometry(GeoJSONFeatureGeometry geometry) {
        this.geometry = geometry;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="geometry")
    @NotNull
    public GeoJSONFeatureGeometry getGeometry() {
        return this.geometry;
    }

    @JsonProperty(value="geometry")
    public void setGeometry(GeoJSONFeatureGeometry geometry) {
        this.geometry = geometry;
    }

    public GeoJSONFeature bbox(List<BigDecimal> bbox) {
        this.bbox = bbox;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bbox")
    @Size(min=4)
    public @Size(min=4) List<BigDecimal> getBbox() {
        return this.bbox;
    }

    @JsonProperty(value="bbox")
    public void setBbox(List<BigDecimal> bbox) {
        this.bbox = bbox;
    }

    public GeoJSONFeature addBboxItem(BigDecimal bboxItem) {
        if (this.bbox == null) {
            this.bbox = new ArrayList<BigDecimal>();
        }
        this.bbox.add(bboxItem);
        return this;
    }

    public GeoJSONFeature removeBboxItem(BigDecimal bboxItem) {
        if (bboxItem != null && this.bbox != null) {
            this.bbox.remove(bboxItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJSONFeature geoJSONFeature = (GeoJSONFeature)o;
        return Objects.equals((Object)this.type, (Object)geoJSONFeature.type) && Objects.equals(this.id, geoJSONFeature.id) && Objects.equals(this.properties, geoJSONFeature.properties) && Objects.equals(this.geometry, geoJSONFeature.geometry) && Objects.equals(this.bbox, geoJSONFeature.bbox);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.properties, this.geometry, this.bbox});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeoJSONFeature {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    geometry: ").append(this.toIndentedString(this.geometry)).append("\n");
        sb.append("    bbox: ").append(this.toIndentedString(this.bbox)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FEATURE(String.valueOf("Feature"));

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromString(String s) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

