/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.ExtentTemporalGrid;

@ApiModel(description="The temporal extent of the features in the collection.")
@JsonTypeName(value="extent_temporal")
public class ExtentTemporal {
    @Valid
    private List<List<Date>> interval = null;
    @Valid
    private TrsEnum trs = TrsEnum.HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN;
    @Valid
    private ExtentTemporalGrid grid;

    public ExtentTemporal interval(List<List<Date>> interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(value="One or more time intervals that describe the temporal extent of the dataset. In the Core only a single time interval is supported.  Extensions may support multiple intervals. The first time interval describes the overall temporal extent of the data. All subsequent time intervals describe more precise time intervals, e.g., to identify clusters of data. Clients only interested in the overall extent will only need to access the first item in each array.")
    @JsonProperty(value="interval")
    @Size(min=1)
    public @Size(min=1) List<@Size(min=2, max=2) List<Date>> getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval(List<List<Date>> interval) {
        this.interval = interval;
    }

    public ExtentTemporal addIntervalItem(List<Date> intervalItem) {
        if (this.interval == null) {
            this.interval = new ArrayList<List<Date>>();
        }
        this.interval.add(intervalItem);
        return this;
    }

    public ExtentTemporal removeIntervalItem(List<Date> intervalItem) {
        if (intervalItem != null && this.interval != null) {
            this.interval.remove(intervalItem);
        }
        return this;
    }

    public ExtentTemporal trs(TrsEnum trs) {
        this.trs = trs;
        return this;
    }

    @ApiModelProperty(value="Coordinate reference system of the coordinates in the temporal extent (property `interval`). The default reference system is the Gregorian calendar. In the Core this is the only supported temporal coordinate reference system. Extensions may support additional temporal coordinate reference systems and add additional enum values.")
    @JsonProperty(value="trs")
    public TrsEnum getTrs() {
        return this.trs;
    }

    @JsonProperty(value="trs")
    public void setTrs(TrsEnum trs) {
        this.trs = trs;
    }

    public ExtentTemporal grid(ExtentTemporalGrid grid) {
        this.grid = grid;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="grid")
    public ExtentTemporalGrid getGrid() {
        return this.grid;
    }

    @JsonProperty(value="grid")
    public void setGrid(ExtentTemporalGrid grid) {
        this.grid = grid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtentTemporal extentTemporal = (ExtentTemporal)o;
        return Objects.equals(this.interval, extentTemporal.interval) && Objects.equals((Object)this.trs, (Object)extentTemporal.trs) && Objects.equals(this.grid, extentTemporal.grid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.trs, this.grid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtentTemporal {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    trs: ").append(this.toIndentedString((Object)this.trs)).append("\n");
        sb.append("    grid: ").append(this.toIndentedString(this.grid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TrsEnum {
        HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN(String.valueOf("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian"));

        private String value;

        private TrsEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static TrsEnum fromString(String s) {
            for (TrsEnum b : TrsEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static TrsEnum fromValue(String value) {
            for (TrsEnum b : TrsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

