/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.baremaps.ogcapi.api.CollectionsApi;
import org.apache.baremaps.ogcapi.model.Collection;
import org.apache.baremaps.ogcapi.model.Collections;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.storage.postgres.PostgresDataSchema;

@Singleton
public class CollectionsResource
implements CollectionsApi {
    @Context
    UriInfo uriInfo;
    private final PostgresDataSchema schema;

    @Inject
    public CollectionsResource(DataSource dataSource) {
        this.schema = new PostgresDataSchema(dataSource);
    }

    @Override
    public Response getCollections() {
        Collections collections = new Collections();
        collections.setTimeStamp(new Date());
        collections.setCollections(this.schema.list().stream().map(arg_0 -> ((PostgresDataSchema)this.schema).get(arg_0)).map(this::getCollection).toList());
        return Response.ok().entity((Object)collections).build();
    }

    @Override
    public Response getCollection(String collectionId) {
        DataTable table = this.schema.get(collectionId);
        Collection collectionInfo = this.getCollection(table);
        return Response.ok().entity((Object)collectionInfo).build();
    }

    private Collection getCollection(DataTable table) {
        String name = table.rowType().name();
        Collection collection = new Collection();
        collection.setId(name);
        collection.setTitle(name);
        collection.setDescription(name);
        collection.setLinks(List.of(new Link().href(this.uriInfo.getBaseUriBuilder().path("collections").path(name).build(new Object[0]).toString()).rel("items").type("application/json")));
        return collection;
    }
}

