/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpResourceRange;
import org.apache.commons.lang3.Validate;

public class IpRange
extends IpResourceRange {
    private static final long serialVersionUID = 1L;

    public static IpRange range(IpAddress start, IpAddress end) {
        return new IpRange(start, end);
    }

    public static IpRange prefix(IpAddress networkNumber, int prefixLength) {
        Validate.notNull((Object)networkNumber, (String)"network number not null", (Object[])new Object[0]);
        Validate.isTrue((prefixLength >= 0 ? 1 : 0) != 0);
        Validate.isTrue((prefixLength <= networkNumber.getType().getBitSize() ? 1 : 0) != 0);
        return new IpRange(networkNumber, prefixLength);
    }

    protected IpRange(IpAddress start, IpAddress end) {
        super(start, end);
    }

    public static IpRange parse(String s) {
        IpResourceRange result = IpResourceRange.parse(s);
        Validate.isTrue((boolean)(result instanceof IpRange), (String)("range is not an IP address range: " + s), (Object[])new Object[0]);
        return (IpRange)result;
    }

    protected IpRange(IpAddress networkNumber, int prefixLength) {
        this(networkNumber, networkNumber.upperBoundForPrefix(prefixLength));
        if (!networkNumber.equals(networkNumber.lowerBoundForPrefix(prefixLength))) {
            throw new IllegalArgumentException("not a valid prefix: " + networkNumber + "/" + prefixLength);
        }
    }

    public boolean isLegalPrefix() {
        int n = this.getPrefixLength();
        return this.getStart().equals(this.getStart().lowerBoundForPrefix(n)) && this.getEnd().equals(this.getEnd().upperBoundForPrefix(n));
    }

    public int getPrefixLength() {
        return this.getStart().getCommonPrefixLength(this.getEnd());
    }

    public List<IpRange> splitToPrefixes() {
        BigInteger rangeEnd = this.getEnd().getValue();
        BigInteger currentRangeStart = this.getStart().getValue();
        int startingPrefixLength = this.getType().getBitSize();
        LinkedList<IpRange> prefixes = new LinkedList<IpRange>();
        while (currentRangeStart.compareTo(rangeEnd) <= 0) {
            int maximumPrefixLength = this.getMaximumLengthOfPrefixStartingAtIpAddressValue(currentRangeStart, startingPrefixLength);
            BigInteger maximumSizeOfPrefix = rangeEnd.subtract(currentRangeStart).add(BigInteger.ONE);
            BigInteger currentSizeOfPrefix = BigInteger.valueOf(2L).pow(maximumPrefixLength);
            while (currentSizeOfPrefix.compareTo(maximumSizeOfPrefix) > 0 && maximumPrefixLength > 0) {
                currentSizeOfPrefix = BigInteger.valueOf(2L).pow(--maximumPrefixLength);
            }
            BigInteger currentRangeEnd = currentRangeStart.add(BigInteger.valueOf(2L).pow(maximumPrefixLength).subtract(BigInteger.ONE));
            IpRange prefix = (IpRange)IpResourceRange.assemble(currentRangeStart, currentRangeEnd, this.getType());
            prefixes.add(prefix);
            currentRangeStart = currentRangeEnd.add(BigInteger.ONE);
        }
        return prefixes;
    }

    private int getMaximumLengthOfPrefixStartingAtIpAddressValue(BigInteger ipAddressValue, int startingPrefixLength) {
        int prefixLength;
        for (prefixLength = startingPrefixLength; prefixLength >= 0 && !this.canBeDividedByThePowerOfTwo(ipAddressValue, prefixLength); --prefixLength) {
        }
        return prefixLength;
    }

    private boolean canBeDividedByThePowerOfTwo(BigInteger number, int power) {
        return number.remainder(BigInteger.valueOf(2L).pow(power)).equals(BigInteger.ZERO);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean defaultMissingOctets) {
        if (this.isLegalPrefix()) {
            return ((IpAddress)this.getStart()).toString(defaultMissingOctets) + "/" + this.getPrefixLength();
        }
        return super.toString();
    }
}

