/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpScheme;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.utils.RedirectingHttpRequesterFilter;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ClientSslConfigBuilder;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultMultiAddressUrlHttpClientBuilder
implements MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultiAddressUrlHttpClientBuilder.class);
    private static final String HTTPS_SCHEME = HttpScheme.HTTPS.toString();
    private final Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> builderFactory;
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    @Nullable
    private HttpHeadersFactory headersFactory;
    @Nullable
    private RedirectConfig redirectConfig;
    @Nullable
    private MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

    DefaultMultiAddressUrlHttpClientBuilder(Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> bFactory) {
        this.builderFactory = Objects.requireNonNull(bFactory);
    }

    public StreamingHttpClient buildStreaming() {
        CompositeCloseable closeables = AsyncCloseables.newCompositeCloseable();
        try {
            HttpExecutionContext executionContext = this.executionContextBuilder.build();
            ClientFactory clientFactory = new ClientFactory(this.builderFactory, executionContext, this.singleAddressInitializer);
            CachingKeyFactory keyFactory = (CachingKeyFactory)closeables.prepend((AsyncCloseable)new CachingKeyFactory());
            HttpHeadersFactory headersFactory = this.headersFactory;
            FilterableStreamingHttpClient urlClient = (FilterableStreamingHttpClient)closeables.prepend((AsyncCloseable)new StreamingUrlHttpClient(executionContext, keyFactory, clientFactory, (StreamingHttpRequestResponseFactory)new DefaultStreamingHttpRequestResponseFactory(executionContext.bufferAllocator(), headersFactory != null ? headersFactory : DefaultHttpHeadersFactory.INSTANCE, HttpProtocolVersion.HTTP_1_1)));
            urlClient = this.redirectConfig == null ? urlClient : new RedirectingHttpRequesterFilter(this.redirectConfig).create(urlClient);
            LOGGER.debug("Multi-address client created with base strategy {}", (Object)executionContext.executionStrategy());
            return new FilterableClientToClient(urlClient, executionContext);
        }
        catch (Throwable t) {
            closeables.closeAsync().subscribe();
            throw t;
        }
    }

    private static void singleClientStrategyUpdate(ContextMap context, HttpExecutionStrategy singleStrategy) {
        HttpExecutionStrategy useStrategy;
        HttpExecutionStrategy requestStrategy = (HttpExecutionStrategy)context.getOrDefault(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)HttpExecutionStrategies.defaultStrategy());
        assert (null != requestStrategy) : "Request strategy unexpectedly null";
        HttpExecutionStrategy httpExecutionStrategy = HttpExecutionStrategies.defaultStrategy() == requestStrategy ? HttpExecutionStrategies.offloadAll() : (useStrategy = HttpExecutionStrategies.defaultStrategy() == singleStrategy || !singleStrategy.hasOffloads() ? requestStrategy : requestStrategy.merge(singleStrategy));
        if (useStrategy != requestStrategy) {
            LOGGER.debug("Request strategy {} changes to {}. SingleAddressClient strategy: {}", new Object[]{requestStrategy, useStrategy, singleStrategy});
            context.put(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)useStrategy);
        }
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executionStrategy(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this;
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> headersFactory(HttpHeadersFactory headersFactory) {
        this.headersFactory = Objects.requireNonNull(headersFactory);
        return this;
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> initializer(MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> initializer) {
        this.singleAddressInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> followRedirects(@Nullable RedirectConfig config) {
        this.redirectConfig = config;
        return this;
    }

    private static final class StreamingUrlHttpClient
    implements FilterableStreamingHttpClient {
        private final HttpExecutionContext executionContext;
        private final StreamingHttpRequestResponseFactory reqRespFactory;
        private final ClientGroup<UrlKey, FilterableStreamingHttpClient> group;
        private final CachingKeyFactory keyFactory;
        private final ListenableAsyncCloseable closeable;

        StreamingUrlHttpClient(HttpExecutionContext executionContext, CachingKeyFactory keyFactory, ClientFactory clientFactory, StreamingHttpRequestResponseFactory reqRespFactory) {
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
            this.group = ClientGroup.from((Function)clientFactory);
            this.keyFactory = keyFactory;
            CompositeCloseable compositeCloseable = AsyncCloseables.newCompositeCloseable();
            compositeCloseable.append(this.group);
            compositeCloseable.append((AsyncCloseable)keyFactory);
            this.closeable = AsyncCloseables.toListenableAsyncCloseable((AsyncCloseable)compositeCloseable);
            this.executionContext = Objects.requireNonNull(executionContext);
        }

        private FilterableStreamingHttpClient selectClient(HttpRequestMetaData metaData) throws MalformedURLException {
            return (FilterableStreamingHttpClient)this.group.get((Object)this.keyFactory.get(metaData));
        }

        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return Single.defer(() -> {
                try {
                    FilterableStreamingHttpClient singleClient = this.selectClient(metaData);
                    DefaultMultiAddressUrlHttpClientBuilder.singleClientStrategyUpdate(metaData.context(), singleClient.executionContext().executionStrategy());
                    return singleClient.reserveConnection(metaData).shareContextOnSubscribe();
                }
                catch (Throwable t) {
                    return Single.failed((Throwable)t).shareContextOnSubscribe();
                }
            });
        }

        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return Single.defer(() -> {
                try {
                    return this.selectClient((HttpRequestMetaData)request).request(request).shareContextOnSubscribe();
                }
                catch (Throwable t) {
                    return Single.failed((Throwable)t).shareContextOnSubscribe();
                }
            });
        }

        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        public Completable onClose() {
            return this.closeable.onClose();
        }

        public Completable onClosing() {
            return this.closeable.onClosing();
        }

        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }

        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }

    private static final class HttpExecutionStrategyUpdater
    implements StreamingHttpClientFilterFactory {
        static final StreamingHttpClientFilterFactory INSTANCE = new HttpExecutionStrategyUpdater();

        private HttpExecutionStrategyUpdater() {
        }

        public StreamingHttpClientFilter create(final FilterableStreamingHttpClient client) {
            return new StreamingHttpClientFilter(client){

                protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                    return Single.defer(() -> {
                        DefaultMultiAddressUrlHttpClientBuilder.singleClientStrategyUpdate(request.context(), client.executionContext().executionStrategy());
                        return delegate.request(request);
                    });
                }
            };
        }

        public HttpExecutionStrategy requiredOffloads() {
            return HttpExecutionStrategies.offloadNone();
        }
    }

    private static final class ClientFactory
    implements Function<UrlKey, FilterableStreamingHttpClient> {
        private static final ClientSslConfig DEFAULT_CLIENT_SSL_CONFIG = new ClientSslConfigBuilder().build();
        private final Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> builderFactory;
        private final HttpExecutionContext executionContext;
        @Nullable
        private final MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

        ClientFactory(Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> builderFactory, HttpExecutionContext executionContext, @Nullable MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer) {
            this.builderFactory = builderFactory;
            this.executionContext = executionContext;
            this.singleAddressInitializer = singleAddressInitializer;
        }

        @Override
        public StreamingHttpClient apply(UrlKey urlKey) {
            SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builder = Objects.requireNonNull(this.builderFactory.apply(urlKey.hostAndPort));
            DefaultSingleAddressHttpClientBuilder.setExecutionContext(builder, this.executionContext);
            if (HTTPS_SCHEME.equalsIgnoreCase(urlKey.scheme)) {
                builder.sslConfig(DEFAULT_CLIENT_SSL_CONFIG);
            }
            builder.appendClientFilter(HttpExecutionStrategyUpdater.INSTANCE);
            if (this.singleAddressInitializer != null) {
                this.singleAddressInitializer.initialize(urlKey.scheme, (Object)urlKey.hostAndPort, builder);
            }
            return builder.buildStreaming();
        }
    }

    private static final class UrlKey {
        final String scheme;
        final HostAndPort hostAndPort;

        UrlKey(String scheme, HostAndPort hostAndPort) {
            this.scheme = scheme;
            this.hostAndPort = hostAndPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlKey urlKey = (UrlKey)o;
            return this.scheme.equals(urlKey.scheme) && this.hostAndPort.equals(urlKey.hostAndPort);
        }

        public int hashCode() {
            return 31 * this.hostAndPort.hashCode() + this.scheme.hashCode();
        }
    }

    private static final class CachingKeyFactory
    implements AsyncCloseable {
        private final ConcurrentMap<String, UrlKey> urlKeyCache = new ConcurrentHashMap<String, UrlKey>();

        private CachingKeyFactory() {
        }

        public UrlKey get(HttpRequestMetaData metaData) throws MalformedURLException {
            String host = metaData.host();
            if (host == null) {
                throw new MalformedURLException("Request-target does not contain target host address: " + metaData.requestTarget() + ", expected absolute-form URL");
            }
            String scheme = metaData.scheme();
            if (scheme == null) {
                throw new MalformedURLException("Request-target does not contains scheme: " + metaData.requestTarget() + ", expected absolute-form URL");
            }
            int parsedPort = metaData.port();
            int port = parsedPort >= 0 ? parsedPort : (HTTPS_SCHEME.equalsIgnoreCase(scheme) ? HttpScheme.HTTPS : HttpScheme.HTTP).port();
            metaData.requestTarget(CachingKeyFactory.absoluteToRelativeFormRequestTarget(metaData.requestTarget(), scheme, host));
            String key = scheme + ':' + host + ':' + port;
            UrlKey urlKey = (UrlKey)this.urlKeyCache.get(key);
            return urlKey != null ? urlKey : this.urlKeyCache.computeIfAbsent(key, ignore -> new UrlKey(scheme, HostAndPort.of((String)host, (int)port)));
        }

        private static String absoluteToRelativeFormRequestTarget(String requestTarget, String scheme, String host) {
            int fromIndex = scheme.length() + 3 + host.length();
            int relativeReferenceIdx = requestTarget.indexOf(47, fromIndex);
            if (relativeReferenceIdx >= 0) {
                return requestTarget.substring(relativeReferenceIdx);
            }
            int questionMarkIdx = requestTarget.indexOf(63, fromIndex);
            return questionMarkIdx < 0 ? "/" : '/' + requestTarget.substring(questionMarkIdx);
        }

        public Completable closeAsync() {
            return new SubscribableCompletable(){

                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    urlKeyCache.clear();
                    SubscriberUtils.deliverCompleteFromSource((CompletableSource.Subscriber)subscriber);
                }
            };
        }
    }
}

