package org.apache.baremaps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.model.MbLayer;
import org.apache.baremaps.model.MbStyleSources;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public class MbStyle   {
  
  private @Valid BigDecimal version;
  private @Valid String name;
  private @Valid Map<String, MbStyleSources> sources = new HashMap<String, MbStyleSources>();
  private @Valid String sprite;
  private @Valid String glyphs;
  private @Valid List<MbLayer> layers = new ArrayList<MbLayer>();
  private @Valid List<BigDecimal> center = new ArrayList<BigDecimal>();
  private @Valid Object metadata;
  private @Valid BigDecimal zoom;

  /**
   **/
  public MbStyle version(BigDecimal version) {
    this.version = version;
    return this;
  }

  

  
  @ApiModelProperty(example = "8", required = true, value = "")
  @JsonProperty("version")
  @NotNull
  public BigDecimal getVersion() {
    return version;
  }

  public void setVersion(BigDecimal version) {
    this.version = version;
  }/**
   **/
  public MbStyle name(String name) {
    this.name = name;
    return this;
  }

  

  
  @ApiModelProperty(example = "night", value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }/**
   **/
  public MbStyle sources(Map<String, MbStyleSources> sources) {
    this.sources = sources;
    return this;
  }

  

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("sources")
  @NotNull
  public Map<String, MbStyleSources> getSources() {
    return sources;
  }

  public void setSources(Map<String, MbStyleSources> sources) {
    this.sources = sources;
  }/**
   **/
  public MbStyle sprite(String sprite) {
    this.sprite = sprite;
    return this;
  }

  

  
  @ApiModelProperty(example = "http://vtp2018.s3-eu-west-1.amazonaws.com/static/mapstorestyle/sprites/sprites", value = "")
  @JsonProperty("sprite")
  public String getSprite() {
    return sprite;
  }

  public void setSprite(String sprite) {
    this.sprite = sprite;
  }/**
   **/
  public MbStyle glyphs(String glyphs) {
    this.glyphs = glyphs;
    return this;
  }

  

  
  @ApiModelProperty(example = "http://fonts.openmaptiles.org/{fontstack}/{range}.pbf", value = "")
  @JsonProperty("glyphs")
  public String getGlyphs() {
    return glyphs;
  }

  public void setGlyphs(String glyphs) {
    this.glyphs = glyphs;
  }/**
   **/
  public MbStyle layers(List<MbLayer> layers) {
    this.layers = layers;
    return this;
  }

  

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("layers")
  @NotNull
  public List<MbLayer> getLayers() {
    return layers;
  }

  public void setLayers(List<MbLayer> layers) {
    this.layers = layers;
  }/**
   **/
  public MbStyle center(List<BigDecimal> center) {
    this.center = center;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("center")
  public List<BigDecimal> getCenter() {
    return center;
  }

  public void setCenter(List<BigDecimal> center) {
    this.center = center;
  }/**
   **/
  public MbStyle metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("metadata")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }/**
   **/
  public MbStyle zoom(BigDecimal zoom) {
    this.zoom = zoom;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("zoom")
  public BigDecimal getZoom() {
    return zoom;
  }

  public void setZoom(BigDecimal zoom) {
    this.zoom = zoom;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MbStyle mbStyle = (MbStyle) o;
    return Objects.equals(this.version, mbStyle.version) &&
        Objects.equals(this.name, mbStyle.name) &&
        Objects.equals(this.sources, mbStyle.sources) &&
        Objects.equals(this.sprite, mbStyle.sprite) &&
        Objects.equals(this.glyphs, mbStyle.glyphs) &&
        Objects.equals(this.layers, mbStyle.layers) &&
        Objects.equals(this.center, mbStyle.center) &&
        Objects.equals(this.metadata, mbStyle.metadata) &&
        Objects.equals(this.zoom, mbStyle.zoom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, name, sources, sprite, glyphs, layers, center, metadata, zoom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MbStyle {\n");
    
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("    sprite: ").append(toIndentedString(sprite)).append("\n");
    sb.append("    glyphs: ").append(toIndentedString(glyphs)).append("\n");
    sb.append("    layers: ").append(toIndentedString(layers)).append("\n");
    sb.append("    center: ").append(toIndentedString(center)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    zoom: ").append(toIndentedString(zoom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

