package org.apache.baremaps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The spatial extend of the resources in the collection.
 **/
@ApiModel(description = "The spatial extend of the resources in the collection.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public class ExtentSpatial   {
  
  private @Valid List<List<Double>> bbox = new ArrayList<List<Double>>();

public enum CrsEnum {

    HTTP_WWW_OPENGIS_NET_DEF_CRS_OGC_1_3_CRS84(String.valueOf("http://www.opengis.net/def/crs/OGC/1.3/CRS84"));


    private String value;

    CrsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static CrsEnum fromValue(String value) {
        for (CrsEnum b : CrsEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid CrsEnum crs = CrsEnum.HTTP_WWW_OPENGIS_NET_DEF_CRS_OGC_1_3_CRS84;

  /**
   * One or more bounding boxes or cubes which describe the spatial extent of the collection. If multiple areas are provided, the union of the bounding boxes describes the spatial extent.
   **/
  public ExtentSpatial bbox(List<List<Double>> bbox) {
    this.bbox = bbox;
    return this;
  }

  

  
  @ApiModelProperty(value = "One or more bounding boxes or cubes which describe the spatial extent of the collection. If multiple areas are provided, the union of the bounding boxes describes the spatial extent.")
  @JsonProperty("bbox")
 @Size(min=1)  public List<List<Double>> getBbox() {
    return bbox;
  }

  public void setBbox(List<List<Double>> bbox) {
    this.bbox = bbox;
  }/**
   * Coordinate reference system of the coordinates in the spatial extent (property &#x60;spatial&#x60;).
   **/
  public ExtentSpatial crs(CrsEnum crs) {
    this.crs = crs;
    return this;
  }

  

  
  @ApiModelProperty(value = "Coordinate reference system of the coordinates in the spatial extent (property `spatial`).")
  @JsonProperty("crs")
  public CrsEnum getCrs() {
    return crs;
  }

  public void setCrs(CrsEnum crs) {
    this.crs = crs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtentSpatial extentSpatial = (ExtentSpatial) o;
    return Objects.equals(this.bbox, extentSpatial.bbox) &&
        Objects.equals(this.crs, extentSpatial.crs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bbox, crs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtentSpatial {\n");
    
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

