/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres.internal;

import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.postgres.internal.BitStringEnumSetColumnMapper;

public class BitStringEnumSetMapperFactory
implements ColumnMapperFactory {
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        if (!EnumSet.class.isAssignableFrom(GenericTypes.getErasedType((Type)type))) {
            return Optional.empty();
        }
        Class enumType = GenericTypes.findGenericParameter((Type)type, EnumSet.class).map(t -> (Class)t).orElseThrow(() -> new IllegalArgumentException("No generic type information for " + type));
        return Optional.of(new BitStringEnumSetColumnMapper(enumType));
    }
}

