/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HttpProviders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.PartitionedHttpClientBuilder;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.DefaultMultiAddressUrlHttpClientBuilder;
import io.servicetalk.http.netty.DefaultPartitionedHttpClientBuilder;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.GlobalDnsServiceDiscoverer;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClients {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClients.class);
    private static final List<HttpProviders.SingleAddressHttpClientBuilderProvider> SINGLE_ADDRESS_PROVIDERS;
    private static final List<HttpProviders.MultiAddressHttpClientBuilderProvider> MULTI_ADDRESS_PROVIDERS;

    private HttpClients() {
    }

    private static <U, R> SingleAddressHttpClientBuilder<U, R> applyProviders(U address, SingleAddressHttpClientBuilder<U, R> builder) {
        for (HttpProviders.SingleAddressHttpClientBuilderProvider provider : SINGLE_ADDRESS_PROVIDERS) {
            builder = provider.newBuilder(address, builder);
        }
        return builder;
    }

    private static <U, R> MultiAddressHttpClientBuilder<U, R> applyProviders(MultiAddressHttpClientBuilder<U, R> builder) {
        for (HttpProviders.MultiAddressHttpClientBuilderProvider provider : MULTI_ADDRESS_PROVIDERS) {
            builder = provider.newBuilder(builder);
        }
        return builder;
    }

    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl() {
        return HttpClients.applyProviders(new DefaultMultiAddressUrlHttpClientBuilder(HttpClients::forSingleAddress));
    }

    @Deprecated
    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl(ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> serviceDiscoverer) {
        return HttpClients.applyProviders(new DefaultMultiAddressUrlHttpClientBuilder(address -> HttpClients.forSingleAddress(serviceDiscoverer, address)));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(String host, int port) {
        return HttpClients.forSingleAddress(HostAndPort.of((String)host, (int)port));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(HostAndPort address) {
        return HttpClients.applyProviders(address, new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(address, GlobalDnsServiceDiscoverer.globalDnsServiceDiscoverer()));
    }

    public static SingleAddressHttpClientBuilder<String, InetSocketAddress> forServiceAddress(String serviceName) {
        return HttpClients.applyProviders(serviceName, new DefaultSingleAddressHttpClientBuilder<String, InetSocketAddress>(serviceName, GlobalDnsServiceDiscoverer.globalSrvDnsServiceDiscoverer()));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(String host, int port) {
        return HttpClients.forResolvedAddress(HostAndPort.of((String)host, (int)port));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(HostAndPort address) {
        return HttpClients.applyProviders(address, new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(address, GlobalDnsServiceDiscoverer.mappingServiceDiscoverer(BuilderUtils::toResolvedInetSocketAddress)));
    }

    public static <R extends SocketAddress> SingleAddressHttpClientBuilder<R, R> forResolvedAddress(R address) {
        return HttpClients.applyProviders(address, new DefaultSingleAddressHttpClientBuilder(address, GlobalDnsServiceDiscoverer.mappingServiceDiscoverer(Function.identity())));
    }

    public static <U, R> SingleAddressHttpClientBuilder<U, R> forSingleAddress(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer, U address) {
        return HttpClients.applyProviders(address, new DefaultSingleAddressHttpClientBuilder<U, R>(address, serviceDiscoverer));
    }

    @Deprecated
    public static <U, R> PartitionedHttpClientBuilder<U, R> forPartitionedAddress(ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer, U address, Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory) {
        return new DefaultPartitionedHttpClientBuilder(address, () -> HttpClients.forSingleAddress(new ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(){
            private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

            public Publisher<Collection<ServiceDiscovererEvent<R>>> discover(U u) {
                return Publisher.failed((Throwable)new IllegalStateException("Invalid service discoverer."));
            }

            public Completable onClose() {
                return this.closeable.onClose();
            }

            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }
        }, address), serviceDiscoverer, partitionAttributesBuilderFactory);
    }

    static {
        ClassLoader classLoader = HttpClients.class.getClassLoader();
        SINGLE_ADDRESS_PROVIDERS = ServiceLoaderUtils.loadProviders(HttpProviders.SingleAddressHttpClientBuilderProvider.class, (ClassLoader)classLoader, (Logger)LOGGER);
        MULTI_ADDRESS_PROVIDERS = ServiceLoaderUtils.loadProviders(HttpProviders.MultiAddressHttpClientBuilderProvider.class, (ClassLoader)classLoader, (Logger)LOGGER);
    }
}

