/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionRejectedException;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerReadyEvent;
import io.servicetalk.client.api.NoAvailableHostException;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.context.api.ContextMap;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RoundRobinLoadBalancer<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancer<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinLoadBalancer.class);
    private static final List<?> CLOSED_LIST = new ArrayList(0);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final AtomicReferenceFieldUpdater<RoundRobinLoadBalancer, List> usedHostsUpdater = AtomicReferenceFieldUpdater.newUpdater(RoundRobinLoadBalancer.class, List.class, "usedHosts");
    private static final AtomicIntegerFieldUpdater<RoundRobinLoadBalancer> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(RoundRobinLoadBalancer.class, "index");
    private static final int MIN_RANDOM_SEARCH_SPACE = 64;
    private static final float RANDOM_SEARCH_FACTOR = 0.75f;
    private volatile int index;
    private volatile List<Host<ResolvedAddress, C>> usedHosts = Collections.emptyList();
    private final String targetResource;
    private final Publisher<Object> eventStream;
    private final SequentialCancellable discoveryCancellable = new SequentialCancellable();
    private final ConnectionFactory<ResolvedAddress, ? extends C> connectionFactory;
    private final int linearSearchSpace;
    private final ListenableAsyncCloseable asyncCloseable;

    RoundRobinLoadBalancer(String targetResourceName, final Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, ? extends C> connectionFactory, int linearSearchSpace, final @Nullable HealthCheckConfig healthCheckConfig) {
        this.targetResource = Objects.requireNonNull(targetResourceName) + " (instance @" + Integer.toHexString(this.hashCode()) + ')';
        final PublisherSource.Processor eventStreamProcessor = Processors.newPublisherProcessorDropHeadOnOverflow((int)32);
        this.eventStream = SourceAdapters.fromSource((PublisherSource)eventStreamProcessor);
        this.connectionFactory = Objects.requireNonNull(connectionFactory);
        this.linearSearchSpace = linearSearchSpace;
        SourceAdapters.toSource(eventPublisher).subscribe(new PublisherSource.Subscriber<Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>>(){

            public void onSubscribe(PublisherSource.Subscription s) {
                s.request(Long.MAX_VALUE);
                RoundRobinLoadBalancer.this.discoveryCancellable.nextCancellable((Cancellable)s);
            }

            public void onNext(Collection<? extends ServiceDiscovererEvent<ResolvedAddress>> events) {
                for (ServiceDiscovererEvent event : events) {
                    ServiceDiscovererEvent.Status eventStatus = event.status();
                    LOGGER.debug("Load balancer for {}: received new ServiceDiscoverer event {}. Inferred status: {}.", new Object[]{RoundRobinLoadBalancer.this.targetResource, event, eventStatus});
                    List usedAddresses = (List)usedHostsUpdater.updateAndGet(RoundRobinLoadBalancer.this, oldHosts -> {
                        if (oldHosts == CLOSED_LIST) {
                            return oldHosts;
                        }
                        Object addr = Objects.requireNonNull(event.address());
                        List oldHostsTyped = oldHosts;
                        if (ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)eventStatus)) {
                            return this.addHostToList(oldHostsTyped, addr);
                        }
                        if (ServiceDiscovererEvent.Status.EXPIRED.equals((Object)eventStatus)) {
                            if (oldHostsTyped.isEmpty()) {
                                return Collections.emptyList();
                            }
                            return this.markHostAsExpired(oldHostsTyped, addr);
                        }
                        if (ServiceDiscovererEvent.Status.UNAVAILABLE.equals((Object)eventStatus)) {
                            return this.listWithHostRemoved(oldHostsTyped, host -> {
                                boolean match = host.address.equals(addr);
                                if (match) {
                                    host.markClosed();
                                }
                                return match;
                            });
                        }
                        LOGGER.error("Load balancer for {}: Unexpected Status in event: {} (mapped to {}). Leaving usedHosts unchanged: {}", new Object[]{RoundRobinLoadBalancer.this.targetResource, event, eventStatus, oldHosts});
                        return oldHosts;
                    });
                    LOGGER.debug("Load balancer for {}: now using {} addresses: {}.", new Object[]{RoundRobinLoadBalancer.this.targetResource, usedAddresses.size(), usedAddresses});
                    if (ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)eventStatus)) {
                        if (usedAddresses.size() != 1) continue;
                        eventStreamProcessor.onNext((Object)LoadBalancerReadyEvent.LOAD_BALANCER_READY_EVENT);
                        continue;
                    }
                    if (!usedAddresses.isEmpty()) continue;
                    eventStreamProcessor.onNext((Object)LoadBalancerReadyEvent.LOAD_BALANCER_NOT_READY_EVENT);
                }
            }

            private List<Host<ResolvedAddress, C>> markHostAsExpired(List<Host<ResolvedAddress, C>> oldHostsTyped, ResolvedAddress addr) {
                for (Host host : oldHostsTyped) {
                    if (!host.address.equals(addr)) continue;
                    host.markExpired();
                    break;
                }
                return oldHostsTyped;
            }

            private Host<ResolvedAddress, C> createHost(ResolvedAddress addr) {
                Host host = new Host(RoundRobinLoadBalancer.this.targetResource, addr, healthCheckConfig);
                host.onClose().afterFinally(() -> {
                    List cfr_ignored_0 = (List)usedHostsUpdater.updateAndGet(RoundRobinLoadBalancer.this, previousHosts -> {
                        List previousHostsTyped = previousHosts;
                        return this.listWithHostRemoved(previousHostsTyped, current -> current == host);
                    });
                }).subscribe();
                return host;
            }

            private List<Host<ResolvedAddress, C>> addHostToList(List<Host<ResolvedAddress, C>> oldHostsTyped, ResolvedAddress addr) {
                if (oldHostsTyped.isEmpty()) {
                    return Collections.singletonList(this.createHost(addr));
                }
                for (Host host : oldHostsTyped) {
                    if (!host.address.equals(addr)) continue;
                    if (!host.markActiveIfNotClosed()) break;
                    return oldHostsTyped;
                }
                ArrayList newHosts = new ArrayList(oldHostsTyped.size() + 1);
                newHosts.addAll(oldHostsTyped);
                newHosts.add(this.createHost(addr));
                return newHosts;
            }

            private List<Host<ResolvedAddress, C>> listWithHostRemoved(List<Host<ResolvedAddress, C>> oldHostsTyped, Predicate<Host<ResolvedAddress, C>> hostPredicate) {
                if (oldHostsTyped.isEmpty()) {
                    return oldHostsTyped;
                }
                ArrayList newHosts = new ArrayList(oldHostsTyped.size() - 1);
                for (int i = 0; i < oldHostsTyped.size(); ++i) {
                    Host current = oldHostsTyped.get(i);
                    if (hostPredicate.test(current)) {
                        for (int x = i + 1; x < oldHostsTyped.size(); ++x) {
                            newHosts.add(oldHostsTyped.get(x));
                        }
                        return newHosts.isEmpty() ? Collections.emptyList() : newHosts;
                    }
                    newHosts.add(current);
                }
                return newHosts;
            }

            public void onError(Throwable t) {
                List hosts = RoundRobinLoadBalancer.this.usedHosts;
                eventStreamProcessor.onError(t);
                LOGGER.error("Load balancer for {}: service discoverer {} emitted an error. Last seen addresses (size {}): {}", new Object[]{RoundRobinLoadBalancer.this.targetResource, eventPublisher, hosts.size(), hosts, t});
            }

            public void onComplete() {
                List hosts = RoundRobinLoadBalancer.this.usedHosts;
                eventStreamProcessor.onComplete();
                LOGGER.error("Load balancer for {}: service discoverer {} completed. Last seen addresses (size {}): {}", new Object[]{RoundRobinLoadBalancer.this.targetResource, eventPublisher, hosts.size(), hosts});
            }
        });
        this.asyncCloseable = AsyncCloseables.toAsyncCloseable(graceful -> {
            List<?> currentList = usedHostsUpdater.getAndSet(this, CLOSED_LIST);
            this.discoveryCancellable.cancel();
            eventStreamProcessor.onComplete();
            CompositeCloseable cc = AsyncCloseables.newCompositeCloseable().appendAll(currentList).appendAll(new AsyncCloseable[]{connectionFactory});
            return graceful ? cc.closeAsyncGracefully() : cc.closeAsync();
        });
    }

    private static <T> Single<T> failedLBClosed(String targetResource) {
        return Single.failed((Throwable)new IllegalStateException("LoadBalancer for " + targetResource + " has closed"));
    }

    public Single<C> selectConnection(Predicate<C> selector, @Nullable ContextMap context) {
        return Single.defer(() -> this.selectConnection0(selector, context).shareContextOnSubscribe());
    }

    public Publisher<Object> eventStream() {
        return this.eventStream;
    }

    public String toString() {
        return "RoundRobinLoadBalancer{targetResource='" + this.targetResource + '\'' + ", usedHosts=" + this.usedHosts + '}';
    }

    private Single<C> selectConnection0(Predicate<C> selector, @Nullable ContextMap context) {
        List<Host<ResolvedAddress, C>> usedHosts = this.usedHosts;
        if (usedHosts.isEmpty()) {
            return usedHosts == CLOSED_LIST ? RoundRobinLoadBalancer.failedLBClosed(this.targetResource) : Single.failed((Throwable)((Object)StacklessNoAvailableHostException.newInstance("No hosts are available to connect for " + this.targetResource + ".", RoundRobinLoadBalancer.class, "selectConnection0(...)")));
        }
        int cursor = (indexUpdater.getAndIncrement(this) & Integer.MAX_VALUE) % usedHosts.size();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        Host<ResolvedAddress, C> pickedHost = null;
        for (int i = 0; i < usedHosts.size(); ++i) {
            int localCursor = (cursor + i) % usedHosts.size();
            Host<ResolvedAddress, C> host = usedHosts.get(localCursor);
            assert (host != null) : "Host can't be null.";
            Object[] connections = ((Host)host).connState.connections;
            int linearAttempts = Math.min(connections.length, this.linearSearchSpace);
            for (int j = 0; j < linearAttempts; ++j) {
                LoadBalancedConnection connection = (LoadBalancedConnection)connections[j];
                if (!selector.test(connection)) continue;
                return Single.succeeded((Object)connection);
            }
            if (connections.length > linearAttempts) {
                int diff = connections.length - linearAttempts;
                int randomAttempts = diff < 64 ? diff : (int)((float)diff * 0.75f);
                for (int j = 0; j < randomAttempts; ++j) {
                    LoadBalancedConnection connection = (LoadBalancedConnection)connections[rnd.nextInt(linearAttempts, connections.length)];
                    if (!selector.test(connection)) continue;
                    return Single.succeeded((Object)connection);
                }
            }
            if (!host.isActiveAndHealthy()) continue;
            pickedHost = host;
            break;
        }
        if (pickedHost == null) {
            return Single.failed((Throwable)((Object)StacklessNoAvailableHostException.newInstance("Failed to pick an active host for " + this.targetResource + ". Either all are busy, expired, or unhealthy: " + usedHosts, RoundRobinLoadBalancer.class, "selectConnection0(...)")));
        }
        Host<ResolvedAddress, C> host = pickedHost;
        Single establishConnection = this.connectionFactory.newConnection(host.address, context, null);
        if (((Host)host).healthCheckConfig != null) {
            establishConnection = establishConnection.beforeOnError(t -> host.markUnhealthy((Throwable)t, (ConnectionFactory<ResolvedAddress, C>)this.connectionFactory));
        }
        return establishConnection.flatMap(newCnx -> {
            if (!selector.test(newCnx)) {
                return newCnx.closeAsync().concat(Single.failed((Throwable)((Object)StacklessConnectionRejectedException.newInstance("Newly created connection " + newCnx + " for " + this.targetResource + " was rejected by the selection filter.", RoundRobinLoadBalancer.class, "selectConnection0(...)"))));
            }
            if (host.addConnection(newCnx)) {
                return Single.succeeded((Object)newCnx);
            }
            return newCnx.closeAsync().concat(this.usedHosts == CLOSED_LIST ? RoundRobinLoadBalancer.failedLBClosed(this.targetResource) : Single.failed((Throwable)((Object)StacklessConnectionRejectedException.newInstance("Failed to add newly created connection " + newCnx + " for " + this.targetResource + " for " + host, RoundRobinLoadBalancer.class, "selectConnection0(...)"))));
        });
    }

    public Completable onClose() {
        return this.asyncCloseable.onClose();
    }

    public Completable closeAsync() {
        return this.asyncCloseable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.asyncCloseable.closeAsyncGracefully();
    }

    List<Map.Entry<ResolvedAddress, List<C>>> usedAddresses() {
        return this.usedHosts.stream().map(Host::asEntry).collect(Collectors.toList());
    }

    private static final class StacklessConnectionRejectedException
    extends ConnectionRejectedException {
        private static final long serialVersionUID = -4940708893680455819L;

        private StacklessConnectionRejectedException(String message) {
            super(message);
        }

        public Throwable fillInStackTrace() {
            return this;
        }

        public static StacklessConnectionRejectedException newInstance(String message, Class<?> clazz, String method) {
            return (StacklessConnectionRejectedException)((Object)ThrowableUtils.unknownStackTrace((Throwable)((Object)new StacklessConnectionRejectedException(message)), clazz, (String)method));
        }
    }

    private static final class StacklessNoAvailableHostException
    extends NoAvailableHostException {
        private static final long serialVersionUID = 5942960040738091793L;

        private StacklessNoAvailableHostException(String message) {
            super(message);
        }

        public Throwable fillInStackTrace() {
            return this;
        }

        public static StacklessNoAvailableHostException newInstance(String message, Class<?> clazz, String method) {
            return (StacklessNoAvailableHostException)((Object)ThrowableUtils.unknownStackTrace((Throwable)((Object)new StacklessNoAvailableHostException(message)), clazz, (String)method));
        }
    }

    private static final class Host<Addr, C extends LoadBalancedConnection>
    implements ListenableAsyncCloseable {
        private static final ActiveState STATE_ACTIVE_NO_FAILURES = new ActiveState();
        private static final ConnState ACTIVE_EMPTY_CONN_STATE = new ConnState(RoundRobinLoadBalancer.access$800(), STATE_ACTIVE_NO_FAILURES);
        private static final ConnState CLOSED_CONN_STATE = new ConnState(RoundRobinLoadBalancer.access$800(), (Object)State.CLOSED);
        private static final AtomicReferenceFieldUpdater<Host, ConnState> connStateUpdater = AtomicReferenceFieldUpdater.newUpdater(Host.class, ConnState.class, "connState");
        private final String targetResource;
        final Addr address;
        @Nullable
        private final HealthCheckConfig healthCheckConfig;
        private final ListenableAsyncCloseable closeable;
        private volatile ConnState connState = ACTIVE_EMPTY_CONN_STATE;

        Host(String targetResource, Addr address, @Nullable HealthCheckConfig healthCheckConfig) {
            this.targetResource = Objects.requireNonNull(targetResource);
            this.address = Objects.requireNonNull(address);
            this.healthCheckConfig = healthCheckConfig;
            this.closeable = AsyncCloseables.toAsyncCloseable(graceful -> graceful ? this.doClose(AsyncCloseable::closeAsyncGracefully) : this.doClose(AsyncCloseable::closeAsync));
        }

        boolean markActiveIfNotClosed() {
            Object oldState = Host.connStateUpdater.getAndUpdate((Host)this, (UnaryOperator<ConnState>)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$markActiveIfNotClosed$1(io.servicetalk.loadbalancer.RoundRobinLoadBalancer$Host$ConnState ), (Lio/servicetalk/loadbalancer/RoundRobinLoadBalancer$Host$ConnState;)Lio/servicetalk/loadbalancer/RoundRobinLoadBalancer$Host$ConnState;)()).state;
            return oldState != State.CLOSED;
        }

        void markClosed() {
            ConnState oldState = connStateUpdater.getAndSet(this, CLOSED_CONN_STATE);
            Object[] toRemove = oldState.connections;
            this.cancelIfHealthCheck(oldState.state);
            LOGGER.debug("Load balancer for {}: closing {} connection(s) gracefully to the closed address: {}.", new Object[]{this.targetResource, toRemove.length, this.address});
            for (Object conn : toRemove) {
                LoadBalancedConnection cConn = (LoadBalancedConnection)conn;
                cConn.closeAsyncGracefully().subscribe();
            }
        }

        void markExpired() {
            block2: {
                State nextState;
                ConnState oldState;
                do {
                    oldState = connStateUpdater.get(this);
                    if (oldState.state == State.EXPIRED || oldState.state == State.CLOSED) break block2;
                } while (!connStateUpdater.compareAndSet(this, oldState, new ConnState(oldState.connections, (Object)(nextState = oldState.connections.length == 0 ? State.CLOSED : State.EXPIRED))));
                this.cancelIfHealthCheck(oldState.state);
                if (nextState == State.CLOSED) {
                    this.closeAsync().subscribe();
                }
            }
        }

        void markHealthy(HealthCheck<Addr, C> originalHealthCheckState) {
            Object oldState = Host.connStateUpdater.getAndUpdate((Host)this, (UnaryOperator<ConnState>)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$markHealthy$2(io.servicetalk.loadbalancer.RoundRobinLoadBalancer$Host$ConnState ), (Lio/servicetalk/loadbalancer/RoundRobinLoadBalancer$Host$ConnState;)Lio/servicetalk/loadbalancer/RoundRobinLoadBalancer$Host$ConnState;)()).state;
            if (oldState != originalHealthCheckState) {
                this.cancelIfHealthCheck(oldState);
            }
        }

        void markUnhealthy(Throwable cause, ConnectionFactory<Addr, ? extends C> connectionFactory) {
            block4: {
                HealthCheck healthCheck;
                assert (this.healthCheckConfig != null);
                while (true) {
                    ConnState previous = connStateUpdater.get(this);
                    if (!ActiveState.class.equals(previous.state.getClass()) || previous.connections.length > 0) {
                        LOGGER.debug("Load balancer for {}: failed to open a new connection to the host on address {}. {}", new Object[]{this.targetResource, this.address, previous, cause});
                        break block4;
                    }
                    ActiveState previousState = (ActiveState)previous.state;
                    if (previousState.failedConnections + 1 < this.healthCheckConfig.failedThreshold) {
                        ActiveState nextState = previousState.forNextFailedConnection();
                        if (!connStateUpdater.compareAndSet(this, previous, new ConnState(previous.connections, nextState))) continue;
                        LOGGER.debug("Load balancer for {}: failed to open a new connection to the host on address {} {} time(s) ({} consecutive failures will trigger health-checking).", new Object[]{this.targetResource, this.address, nextState.failedConnections, this.healthCheckConfig.failedThreshold, cause});
                        break block4;
                    }
                    healthCheck = new HealthCheck(connectionFactory, this, cause);
                    ConnState nextState = new ConnState(previous.connections, (Object)healthCheck);
                    if (connStateUpdater.compareAndSet(this, previous, nextState)) break;
                }
                LOGGER.info("Load balancer for {}: failed to open a new connection to the host on address {} {} time(s) in a row. Error counting threshold reached, marking this host as UNHEALTHY for the selection algorithm and triggering background health-checking.", new Object[]{this.targetResource, this.address, this.healthCheckConfig.failedThreshold, cause});
                healthCheck.schedule(cause);
            }
        }

        boolean isActiveAndHealthy() {
            return ActiveState.class.equals(this.connState.state.getClass());
        }

        boolean addConnection(C connection) {
            Object newState;
            Object[] newList;
            ConnState previous;
            int addAttempt = 0;
            do {
                ++addAttempt;
                previous = connStateUpdater.get(this);
                if (previous == CLOSED_CONN_STATE) {
                    return false;
                }
                Object[] existing = previous.connections;
                newList = Arrays.copyOf(existing, existing.length + 1);
                newList[existing.length] = connection;
            } while (!connStateUpdater.compareAndSet(this, previous, new ConnState(newList, newState = ActiveState.class.equals(previous.state.getClass()) ? STATE_ACTIVE_NO_FAILURES : previous.state)));
            LOGGER.trace("Load balancer for {}: added a new connection {} to {} after {} attempt(s).", new Object[]{this.targetResource, connection, this, addAttempt});
            connection.onClose().beforeFinally(() -> {
                int removeAttempt = 0;
                while (true) {
                    int i;
                    ++removeAttempt;
                    ConnState currentConnState = this.connState;
                    if (currentConnState == CLOSED_CONN_STATE) break;
                    Object[] connections = currentConnState.connections;
                    for (i = 0; i < connections.length && !connections[i].equals(connection); ++i) {
                    }
                    if (i == connections.length) break;
                    if (connections.length == 1) {
                        if (ActiveState.class.equals(currentConnState.state.getClass())) {
                            if (!connStateUpdater.compareAndSet(this, currentConnState, new ConnState(EMPTY_ARRAY, currentConnState.state))) continue;
                        } else {
                            if (currentConnState.state != State.EXPIRED || !connStateUpdater.compareAndSet(this, currentConnState, CLOSED_CONN_STATE)) continue;
                            this.closeAsync().subscribe();
                        }
                        break;
                    }
                    Object[] newList = new Object[connections.length - 1];
                    System.arraycopy(connections, 0, newList, 0, i);
                    System.arraycopy(connections, i + 1, newList, i, newList.length - i);
                    if (connStateUpdater.compareAndSet(this, currentConnState, new ConnState(newList, currentConnState.state))) break;
                }
                LOGGER.trace("Load balancer for {}: removed connection {} from {} after {} attempt(s).", new Object[]{this.targetResource, connection, this, removeAttempt});
            }).subscribe();
            return true;
        }

        Map.Entry<Addr, List<C>> asEntry() {
            return new AbstractMap.SimpleImmutableEntry(this.address, Stream.of(this.connState.connections).map(conn -> (LoadBalancedConnection)conn).collect(Collectors.toList()));
        }

        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }

        public Completable onClose() {
            return this.closeable.onClose();
        }

        private Completable doClose(Function<? super C, Completable> closeFunction) {
            return Completable.defer(() -> {
                ConnState oldState = connStateUpdater.getAndSet(this, CLOSED_CONN_STATE);
                this.cancelIfHealthCheck(oldState.state);
                Object[] connections = oldState.connections;
                return connections.length == 0 ? Completable.completed() : Publisher.from((Object[])connections).flatMapCompletableDelayError(conn -> (Completable)closeFunction.apply((Object)((LoadBalancedConnection)conn)));
            });
        }

        private void cancelIfHealthCheck(Object o) {
            if (HealthCheck.class.equals(o.getClass())) {
                HealthCheck healthCheck = (HealthCheck)((Object)o);
                LOGGER.debug("Load balancer for {}: health check cancelled for {}.", (Object)this.targetResource, (Object)healthCheck.host);
                healthCheck.cancel();
            }
        }

        public String toString() {
            ConnState connState = this.connState;
            return "Host{address=" + this.address + ", state=" + connState.state + ", #connections=" + connState.connections.length + '}';
        }

        private static /* synthetic */ ConnState lambda$markHealthy$2(ConnState previous) {
            if (HealthCheck.class.equals(previous.state.getClass())) {
                return new ConnState(previous.connections, STATE_ACTIVE_NO_FAILURES);
            }
            return previous;
        }

        private static /* synthetic */ ConnState lambda$markActiveIfNotClosed$1(ConnState oldConnState) {
            if (oldConnState.state == State.EXPIRED) {
                return new ConnState(oldConnState.connections, STATE_ACTIVE_NO_FAILURES);
            }
            return oldConnState;
        }

        private static final class ConnState {
            final Object[] connections;
            final Object state;

            ConnState(Object[] connections, Object state) {
                this.connections = connections;
                this.state = state;
            }

            public String toString() {
                return "ConnState{state=" + this.state + ", #connections=" + this.connections.length + '}';
            }
        }

        private static final class HealthCheck<ResolvedAddress, C extends LoadBalancedConnection>
        extends DelayedCancellable {
            private final ConnectionFactory<ResolvedAddress, ? extends C> connectionFactory;
            private final Host<ResolvedAddress, C> host;
            private final Throwable lastError;

            private HealthCheck(ConnectionFactory<ResolvedAddress, ? extends C> connectionFactory, Host<ResolvedAddress, C> host, Throwable lastError) {
                this.connectionFactory = connectionFactory;
                this.host = host;
                this.lastError = lastError;
            }

            public void schedule(Throwable originalCause) {
                assert (((Host)this.host).healthCheckConfig != null);
                this.delayedCancellable(((Completable)RetryStrategies.retryWithConstantBackoffDeltaJitter(cause -> true, (Duration)((Host)this.host).healthCheckConfig.healthCheckInterval, (Duration)((Host)this.host).healthCheckConfig.jitter, (Executor)((Host)this.host).healthCheckConfig.executor).apply(0, (Object)originalCause)).beforeOnSubscribe(__ -> AsyncContext.clear()).concat(this.connectionFactory.newConnection(this.host.address, null, null).retryWhen(RetryStrategies.retryWithConstantBackoffDeltaJitter(cause -> {
                    LOGGER.debug("Load balancer for {}: health check failed for {}.", new Object[]{((Host)this.host).targetResource, this.host, cause});
                    return true;
                }, (Duration)((Host)this.host).healthCheckConfig.healthCheckInterval, (Duration)((Host)this.host).healthCheckConfig.jitter, (Executor)((Host)this.host).healthCheckConfig.executor))).flatMapCompletable(newCnx -> {
                    if (this.host.addConnection((LoadBalancedConnection)newCnx)) {
                        this.host.markHealthy(this);
                        LOGGER.info("Load balancer for {}: health check passed for {}, marking this host as ACTIVE for the selection algorithm.", (Object)((Host)this.host).targetResource, this.host);
                        return Completable.completed();
                    }
                    LOGGER.debug("Load balancer for {}: health check passed for {}, but the host rejected a new connection {}. Closing it now.", new Object[]{((Host)this.host).targetResource, this.host, newCnx});
                    return newCnx.closeAsync();
                }).onErrorComplete(t -> {
                    LOGGER.error("Load balancer for {}: health check terminated with an unexpected error for {}. Marking this host as ACTIVE as a fallback to allow connection attempts.", new Object[]{((Host)this.host).targetResource, this.host, t});
                    this.host.markHealthy(this);
                    return true;
                }).subscribe());
            }

            public String toString() {
                return "UNHEALTHY(" + this.lastError + ')';
            }
        }

        private static final class ActiveState {
            private final int failedConnections;

            ActiveState() {
                this(0);
            }

            private ActiveState(int failedConnections) {
                this.failedConnections = failedConnections;
            }

            ActiveState forNextFailedConnection() {
                return new ActiveState(FlowControlUtils.addWithOverflowProtection((int)this.failedConnections, (int)1));
            }

            public String toString() {
                return "ACTIVE(failedConnections=" + this.failedConnections + ')';
            }
        }

        private static enum State {
            EXPIRED,
            CLOSED;

        }
    }

    static final class HealthCheckConfig {
        private final Executor executor;
        private final Duration healthCheckInterval;
        private final Duration jitter;
        private final int failedThreshold;

        HealthCheckConfig(Executor executor, Duration healthCheckInterval, Duration healthCheckJitter, int failedThreshold) {
            this.executor = executor;
            this.healthCheckInterval = healthCheckInterval;
            this.failedThreshold = failedThreshold;
            this.jitter = healthCheckJitter;
        }
    }
}

