/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.transport.api.DefaultExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ExecutionContextBuilder<ES extends ExecutionStrategy> {
    protected final Supplier<ExecutionContext<ES>> defaultContextSupplier;
    @Nullable
    protected IoExecutor ioExecutor;
    @Nullable
    protected Executor executor;
    @Nullable
    protected BufferAllocator allocator;
    @Nullable
    protected ES strategy;

    public ExecutionContextBuilder() {
        this.defaultContextSupplier = () -> GlobalExecutionContext.globalExecutionContext();
    }

    public ExecutionContextBuilder(ExecutionContext<ES> defaultContext) {
        this.defaultContextSupplier = () -> Objects.requireNonNull(defaultContext);
    }

    public ExecutionContextBuilder(ExecutionContextBuilder<ES> other) {
        this.defaultContextSupplier = other.defaultContextSupplier;
        this.ioExecutor = other.ioExecutor;
        this.executor = other.executor;
        this.allocator = other.allocator;
        this.strategy = other.strategy;
    }

    public ExecutionContextBuilder<ES> ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = Objects.requireNonNull(ioExecutor);
        return this;
    }

    public ExecutionContextBuilder<ES> executor(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    public ExecutionContextBuilder<ES> bufferAllocator(BufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator);
        return this;
    }

    public ExecutionContextBuilder<ES> executionStrategy(ES strategy) {
        this.strategy = (ExecutionStrategy)Objects.requireNonNull(strategy);
        return this;
    }

    public ExecutionContext<ES> build() {
        if (this.ioExecutor == null && this.executor == null && this.allocator == null && this.strategy == null) {
            return this.defaultContextSupplier.get();
        }
        return new DefaultExecutionContext(this.allocator == null ? this.defaultContextSupplier.get().bufferAllocator() : this.allocator, this.ioExecutor == null ? this.defaultContextSupplier.get().ioExecutor() : this.ioExecutor, this.executor == null ? this.defaultContextSupplier.get().executor() : this.executor, this.strategy == null ? this.defaultContextSupplier.get().executionStrategy() : this.strategy);
    }
}

