/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import java.util.Objects;

final class BatchFlush
implements FlushStrategy {
    private final Publisher<?> boundaries;
    private final int batchSize;

    BatchFlush(Publisher<?> durationBoundaries, int batchSize) {
        this.boundaries = Objects.requireNonNull(durationBoundaries);
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize + " (expected > 0)");
        }
        this.batchSize = batchSize;
    }

    @Override
    public FlushStrategy.WriteEventsListener apply(FlushStrategy.FlushSender sender) {
        return new BatchFlushListener(this.boundaries, this.batchSize, sender);
    }

    static final class BatchFlushListener
    implements FlushStrategy.WriteEventsListener {
        private final Publisher<?> boundaries;
        private final int batchSize;
        private final FlushStrategy.FlushSender sender;
        private final DelayedCancellable boundariesCancellable = new DelayedCancellable();
        private int unflushedCount;

        BatchFlushListener(Publisher<?> boundaries, int batchSize, FlushStrategy.FlushSender sender) {
            this.boundaries = boundaries;
            this.batchSize = batchSize;
            this.sender = sender;
        }

        @Override
        public void writeStarted() {
            this.boundariesCancellable.delayedCancellable(this.boundaries.forEach(__ -> this.sender.flush()));
        }

        @Override
        public void itemWritten(Object __) {
            if (++this.unflushedCount == this.batchSize) {
                this.unflushedCount = 0;
                this.sender.flush();
            }
        }

        @Override
        public void writeTerminated() {
            this.boundariesCancellable.cancel();
            if (this.unflushedCount > 0) {
                this.sender.flush();
            }
        }

        @Override
        public void writeCancelled() {
            this.boundariesCancellable.cancel();
        }
    }
}

