/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.exceptions.ValueHandlerAlreadyRegisteredException;
import de.bytefish.pgbulkinsert.exceptions.ValueHandlerNotRegisteredException;
import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.handlers.BigDecimalValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BooleanValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BoxValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteArrayValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.CircleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.HstoreValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.JsonbValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LineSegmentValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LineValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.MacAddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PathValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PointValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PolygonValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.RangeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.UUIDValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ZonedDateTimeValueHandler;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValueHandlerProvider
implements IValueHandlerProvider {
    private final Map<DataType, IValueHandler> valueHandlers = new EnumMap<DataType, IValueHandler>(DataType.class);

    public ValueHandlerProvider() {
        this.add(DataType.Boolean, new BooleanValueHandler());
        this.add(DataType.Char, new ByteValueHandler());
        this.add(DataType.Numeric, new BigDecimalValueHandler());
        this.add(DataType.DoublePrecision, new DoubleValueHandler());
        this.add(DataType.SinglePrecision, new FloatValueHandler());
        this.add(DataType.Date, new LocalDateValueHandler());
        this.add(DataType.Time, new LocalTimeValueHandler());
        this.add(DataType.Timestamp, new LocalDateTimeValueHandler());
        this.add(DataType.TimestampTz, new ZonedDateTimeValueHandler());
        this.add(DataType.Int2, new ShortValueHandler());
        this.add(DataType.Int4, new IntegerValueHandler());
        this.add(DataType.Int8, new LongValueHandler());
        this.add(DataType.Text, new StringValueHandler());
        this.add(DataType.VarChar, new StringValueHandler());
        this.add(DataType.Inet4, new Inet4AddressValueHandler());
        this.add(DataType.Inet6, new Inet6AddressValueHandler());
        this.add(DataType.Uuid, new UUIDValueHandler());
        this.add(DataType.Bytea, new ByteArrayValueHandler());
        this.add(DataType.Jsonb, new JsonbValueHandler());
        this.add(DataType.Hstore, new HstoreValueHandler());
        this.add(DataType.Point, new PointValueHandler());
        this.add(DataType.Box, new BoxValueHandler());
        this.add(DataType.Line, new LineValueHandler());
        this.add(DataType.LineSegment, new LineSegmentValueHandler());
        this.add(DataType.Path, new PathValueHandler());
        this.add(DataType.Polygon, new PolygonValueHandler());
        this.add(DataType.Circle, new CircleValueHandler());
        this.add(DataType.MacAddress, new MacAddressValueHandler());
        this.add(DataType.TsRange, new RangeValueHandler<LocalDateTime>(new LocalDateTimeValueHandler()));
        this.add(DataType.TsTzRange, new RangeValueHandler<ZonedDateTime>(new ZonedDateTimeValueHandler()));
        this.add(DataType.Int4Range, new RangeValueHandler(new IntegerValueHandler()));
        this.add(DataType.Int8Range, new RangeValueHandler(new LongValueHandler()));
        this.add(DataType.NumRange, new RangeValueHandler(new BigDecimalValueHandler()));
        this.add(DataType.DateRange, new RangeValueHandler<LocalDate>(new LocalDateValueHandler()));
    }

    public <TTargetType> ValueHandlerProvider add(DataType targetType, IValueHandler<TTargetType> valueHandler) {
        if (this.valueHandlers.containsKey((Object)targetType)) {
            throw new ValueHandlerAlreadyRegisteredException(String.format("TargetType '%s' has already been registered", new Object[]{targetType}));
        }
        this.valueHandlers.put(targetType, valueHandler);
        return this;
    }

    @Override
    public <TTargetType> IValueHandler<TTargetType> resolve(DataType dataType) {
        IValueHandler handler = this.valueHandlers.get((Object)dataType);
        if (handler == null) {
            throw new ValueHandlerNotRegisteredException(String.format("DataType '%s' has not been registered", new Object[]{dataType}));
        }
        return handler;
    }

    public String toString() {
        String valueHandlersString = this.valueHandlers.entrySet().stream().map(e -> ((IValueHandler)e.getValue()).toString()).collect(Collectors.joining(", "));
        return "ValueHandlerProvider{valueHandlers=[" + valueHandlersString + "]" + '}';
    }
}

