/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.ComposedCancellable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SingleTerminalSignalConsumer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class AfterFinallySingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final SingleTerminalSignalConsumer<? super T> doFinally;

    AfterFinallySingle(Single<T> original, SingleTerminalSignalConsumer<? super T> doFinally) {
        super(original);
        this.doFinally = Objects.requireNonNull(doFinally);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new AfterFinallySingleSubscriber<T>(subscriber, this.doFinally);
    }

    private static final class AfterFinallySingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final SingleTerminalSignalConsumer<? super T> doFinally;
        private static final AtomicIntegerFieldUpdater<AfterFinallySingleSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(AfterFinallySingleSubscriber.class, "done");
        private volatile int done;

        AfterFinallySingleSubscriber(SingleSource.Subscriber<? super T> original, SingleTerminalSignalConsumer<? super T> doFinally) {
            this.original = original;
            this.doFinally = doFinally;
        }

        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe((Cancellable)new ComposedCancellable(originalCancellable, () -> {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.cancel();
                }
            }));
        }

        public void onSuccess(T value) {
            try {
                this.original.onSuccess(value);
            }
            finally {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onSuccess(value);
                }
            }
        }

        public void onError(Throwable cause) {
            try {
                this.original.onError(cause);
            }
            finally {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onError(cause);
                }
            }
        }
    }
}

