/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.ColumnConstraints;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;
import mil.nga.geopackage.db.table.Constraints;
import mil.nga.geopackage.db.table.RawConstraint;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.user.UserTable;

public abstract class UserColumn
implements Comparable<UserColumn> {
    private static final Logger log = Logger.getLogger(UserColumn.class.getName());
    public static final int NO_INDEX = -1;
    public static final int NOT_NULL_CONSTRAINT_ORDER = 1;
    public static final int DEFAULT_VALUE_CONSTRAINT_ORDER = 2;
    public static final int PRIMARY_KEY_CONSTRAINT_ORDER = 3;
    public static final int AUTOINCREMENT_CONSTRAINT_ORDER = 4;
    public static final int UNIQUE_CONSTRAINT_ORDER = 5;
    private int index;
    private String name;
    private Long max;
    private boolean notNull;
    private Object defaultValue;
    private boolean primaryKey;
    private boolean autoincrement;
    private boolean unique;
    private String type;
    private GeoPackageDataType dataType;
    private final Constraints constraints;

    protected UserColumn(int index, String name, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey, boolean autoincrement) {
        this(index, name, UserColumn.getTypeName(name, dataType), dataType, max, notNull, defaultValue, primaryKey, autoincrement);
    }

    protected UserColumn(int index, String name, String type, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey, boolean autoincrement) {
        this.index = index;
        this.name = name;
        this.max = max;
        this.notNull = notNull;
        this.defaultValue = defaultValue;
        this.primaryKey = primaryKey;
        this.autoincrement = autoincrement;
        this.type = type;
        this.dataType = dataType;
        this.constraints = new Constraints();
        UserColumn.validateDataType(name, dataType);
        this.validateMax();
        this.addDefaultConstraints();
    }

    protected UserColumn(TableColumn tableColumn) {
        this(tableColumn.getIndex(), tableColumn.getName(), tableColumn.getType(), tableColumn.getDataType(), tableColumn.getMax(), tableColumn.isNotNull() || tableColumn.isPrimarykey(), tableColumn.getDefaultValue(), tableColumn.isPrimarykey(), tableColumn.isPrimarykey() && UserTable.DEFAULT_AUTOINCREMENT);
    }

    protected UserColumn(UserColumn userColumn) {
        this.index = userColumn.index;
        this.name = userColumn.name;
        this.max = userColumn.max;
        this.notNull = userColumn.notNull;
        this.defaultValue = userColumn.defaultValue;
        this.primaryKey = userColumn.primaryKey;
        this.autoincrement = userColumn.autoincrement;
        this.type = userColumn.type;
        this.dataType = userColumn.dataType;
        this.constraints = userColumn.constraints.copy();
    }

    protected static String getTypeName(String name, GeoPackageDataType dataType) {
        UserColumn.validateDataType(name, dataType);
        return dataType.name();
    }

    protected static void validateDataType(String name, GeoPackageDataType dataType) {
        if (dataType == null) {
            log.log(Level.SEVERE, "Column is missing a data type: " + name);
        }
    }

    public abstract UserColumn copy();

    public boolean hasIndex() {
        return this.index > -1;
    }

    public void setIndex(int index) {
        if (this.hasIndex()) {
            if (index != this.index) {
                throw new GeoPackageException("User Column with a valid index may not be changed. Column Name: " + this.name + ", Index: " + this.index + ", Attempted Index: " + index);
            }
        } else {
            this.index = index;
        }
    }

    public void resetIndex() {
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNamed(String name) {
        return this.name.equals(name);
    }

    public boolean hasMax() {
        return this.max != null;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getMax() {
        return this.max;
    }

    public void setNotNull(boolean notNull) {
        if (this.notNull != notNull) {
            if (notNull) {
                this.addNotNullConstraint();
            } else {
                this.removeNotNullConstraint();
            }
        }
        this.notNull = notNull;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public void setDefaultValue(Object defaultValue) {
        this.removeDefaultValueConstraint();
        if (defaultValue != null) {
            this.addDefaultValueConstraint(defaultValue);
        }
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setPrimaryKey(boolean primaryKey) {
        if (this.primaryKey != primaryKey) {
            if (primaryKey) {
                this.addPrimaryKeyConstraint();
            } else {
                this.removeAutoincrementConstraint();
                this.removePrimaryKeyConstraint();
            }
        }
        this.primaryKey = primaryKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setAutoincrement(boolean autoincrement) {
        if (this.autoincrement != autoincrement) {
            if (autoincrement) {
                this.addAutoincrementConstraint();
            } else {
                this.removeAutoincrementConstraint();
            }
        }
        this.autoincrement = autoincrement;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setUnique(boolean unique) {
        if (this.unique != unique) {
            if (unique) {
                this.addUniqueConstraint();
            } else {
                this.removeUniqueConstraint();
            }
        }
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setDataType(GeoPackageDataType dataType) {
        this.dataType = dataType;
    }

    public GeoPackageDataType getDataType() {
        return this.dataType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasConstraints() {
        return this.constraints.has();
    }

    public boolean hasConstraints(ConstraintType type) {
        return this.constraints.has(type);
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public List<Constraint> getConstraints(ConstraintType type) {
        return this.constraints.get(type);
    }

    public List<Constraint> clearConstraints() {
        return this.clearConstraints(true);
    }

    public List<Constraint> clearConstraints(boolean reset) {
        if (reset) {
            this.primaryKey = false;
            this.unique = false;
            this.notNull = false;
            this.defaultValue = null;
            this.autoincrement = false;
        }
        return this.constraints.clear();
    }

    public List<Constraint> clearConstraints(ConstraintType type) {
        switch (type) {
            case PRIMARY_KEY: {
                this.primaryKey = false;
                break;
            }
            case UNIQUE: {
                this.unique = false;
                break;
            }
            case NOT_NULL: {
                this.notNull = false;
                break;
            }
            case DEFAULT: {
                this.defaultValue = null;
                break;
            }
            case AUTOINCREMENT: {
                this.autoincrement = false;
                break;
            }
        }
        return this.constraints.clear(type);
    }

    public void addDefaultConstraints() {
        if (this.isNotNull()) {
            this.addNotNullConstraint();
        }
        if (this.hasDefaultValue()) {
            this.addDefaultValueConstraint(this.getDefaultValue());
        }
        if (this.isPrimaryKey()) {
            this.addPrimaryKeyConstraint();
        }
        if (this.isAutoincrement()) {
            this.addAutoincrementConstraint();
        }
    }

    public void addConstraint(Constraint constraint) {
        if (constraint.getOrder() == null) {
            this.setConstraintOrder(constraint);
        }
        this.constraints.add(constraint);
        switch (constraint.getType()) {
            case PRIMARY_KEY: {
                this.primaryKey = true;
                break;
            }
            case UNIQUE: {
                this.unique = true;
                break;
            }
            case NOT_NULL: {
                this.notNull = true;
                break;
            }
            case DEFAULT: {
                break;
            }
            case AUTOINCREMENT: {
                this.autoincrement = true;
                break;
            }
        }
    }

    public void setConstraintOrder(Constraint constraint) {
        Integer order = null;
        switch (constraint.getType()) {
            case PRIMARY_KEY: {
                order = 3;
                break;
            }
            case UNIQUE: {
                order = 5;
                break;
            }
            case NOT_NULL: {
                order = 1;
                break;
            }
            case DEFAULT: {
                order = 2;
                break;
            }
            case AUTOINCREMENT: {
                order = 4;
                break;
            }
        }
        constraint.setOrder(order);
    }

    public void addConstraint(String constraint) {
        this.addConstraint(new RawConstraint(constraint));
    }

    public void addConstraint(ConstraintType type, String constraint) {
        this.addConstraint(type, null, constraint);
    }

    public void addConstraint(ConstraintType type, Integer order, String constraint) {
        this.addConstraint(new RawConstraint(type, order, constraint));
    }

    public void addConstraints(Collection<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            this.addConstraint(constraint);
        }
    }

    public void addConstraints(ColumnConstraints constraints) {
        this.addConstraints(constraints.getConstraints());
    }

    public void addConstraints(Constraints constraints) {
        this.addConstraints(constraints.all());
    }

    public void addNotNullConstraint() {
        this.addConstraint(ConstraintType.NOT_NULL, 1, "NOT NULL");
    }

    public void removeNotNullConstraint() {
        this.clearConstraints(ConstraintType.NOT_NULL);
    }

    public void addDefaultValueConstraint(Object defaultValue) {
        this.addConstraint(ConstraintType.DEFAULT, 2, "DEFAULT " + CoreSQLUtils.columnDefaultValue(defaultValue, this.getDataType()));
    }

    public void removeDefaultValueConstraint() {
        this.clearConstraints(ConstraintType.DEFAULT);
    }

    public void addPrimaryKeyConstraint() {
        this.addConstraint(ConstraintType.PRIMARY_KEY, 3, "PRIMARY KEY");
    }

    public void removePrimaryKeyConstraint() {
        this.clearConstraints(ConstraintType.PRIMARY_KEY);
    }

    public void addAutoincrementConstraint() {
        this.addConstraint(ConstraintType.AUTOINCREMENT, 4, "AUTOINCREMENT");
    }

    public void removeAutoincrementConstraint() {
        this.clearConstraints(ConstraintType.AUTOINCREMENT);
    }

    public void addUniqueConstraint() {
        this.addConstraint(ConstraintType.UNIQUE, 5, "UNIQUE");
    }

    public void removeUniqueConstraint() {
        this.clearConstraints(ConstraintType.UNIQUE);
    }

    public String buildConstraintSql(Constraint constraint) {
        String sql = null;
        if (UserTable.DEFAULT_PK_NOT_NULL || !this.isPrimaryKey() || constraint.getType() != ConstraintType.NOT_NULL) {
            sql = constraint.buildSql();
        }
        return sql;
    }

    @Override
    public int compareTo(UserColumn another) {
        return this.index - another.index;
    }

    private void validateMax() {
        if (this.max != null) {
            if (this.dataType == null) {
                log.log(Level.SEVERE, "Column max set on a column without a data type. column: " + this.name + ", max: " + this.max);
            } else if (this.dataType != GeoPackageDataType.TEXT && this.dataType != GeoPackageDataType.BLOB) {
                throw new GeoPackageException("Column max is only supported for " + GeoPackageDataType.TEXT.name() + " and " + GeoPackageDataType.BLOB.name() + " columns. column: " + this.name + ", max: " + this.max + ", type: " + this.dataType.name());
            }
        }
    }
}

