/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import java.util.Iterator;
import java.util.Map;
import org.apache.baremaps.collection.AppendOnlyBuffer;
import org.apache.baremaps.collection.DataList;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.collection.MemoryAlignedDataList;
import org.apache.baremaps.collection.type.LongDataType;
import org.apache.baremaps.collection.type.PairDataType;

public class MonotonicDataMap<E>
extends DataMap<E> {
    private final DataList<Long> offsets;
    private final DataList<PairDataType.Pair<Long, Long>> keys;
    private final AppendOnlyBuffer<E> values;
    private long lastChunk = -1L;

    public MonotonicDataMap(AppendOnlyBuffer<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType())), values);
    }

    public MonotonicDataMap(DataList<PairDataType.Pair<Long, Long>> keys, AppendOnlyBuffer<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), keys, values);
    }

    public MonotonicDataMap(DataList<Long> offsets, DataList<PairDataType.Pair<Long, Long>> keys, AppendOnlyBuffer<E> values) {
        this.offsets = offsets;
        this.keys = keys;
        this.values = values;
    }

    @Override
    public E put(Long key, E value) {
        long index = this.keys.sizeAsLong();
        long chunk = key >>> 8;
        if (chunk != this.lastChunk) {
            while (this.offsets.sizeAsLong() <= chunk) {
                this.offsets.add(index);
            }
            this.lastChunk = chunk;
        }
        long position = this.values.addPositioned(value);
        this.keys.add(new PairDataType.Pair<Long, Long>(key, position));
        return null;
    }

    @Override
    public E get(Object keyObject) {
        long key = (Long)keyObject;
        long chunk = key >>> 8;
        if (chunk >= this.offsets.sizeAsLong()) {
            return null;
        }
        long lo = this.offsets.get(chunk);
        long hi = Math.min(this.keys.sizeAsLong(), chunk >= this.offsets.sizeAsLong() - 1L ? this.keys.sizeAsLong() : this.offsets.get(chunk + 1L).longValue()) - 1L;
        while (lo <= hi) {
            long index = lo + hi >>> 1;
            PairDataType.Pair<Long, Long> pair = this.keys.get(index);
            long value = pair.left();
            if (value < key) {
                lo = index + 1L;
                continue;
            }
            if (value > key) {
                hi = index - 1L;
                continue;
            }
            return this.values.read(pair.right());
        }
        return null;
    }

    @Override
    protected Iterator<Long> keyIterator() {
        return this.keys.stream().map(PairDataType.Pair::left).iterator();
    }

    @Override
    protected Iterator<E> valueIterator() {
        return this.keys.stream().map(PairDataType.Pair::right).map(this.values::read).iterator();
    }

    @Override
    protected Iterator<Map.Entry<Long, E>> entryIterator() {
        return this.keys.stream().map(p -> Map.entry((Long)p.left(), this.values.read((Long)p.right()))).iterator();
    }

    @Override
    public long sizeAsLong() {
        return this.keys.sizeAsLong();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.keys.clear();
        this.values.clear();
    }
}

