/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.Collection;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Types;

public class ExpressionUtil {
    public static Expression convertPartitionDataToDataFilter(MixedTable table, int specId, Collection<StructLike> partitions) {
        False filter = Expressions.alwaysFalse();
        for (StructLike partition : partitions) {
            filter = Expressions.or((Expression)filter, (Expression)ExpressionUtil.convertPartitionDataToDataFilter(table, specId, partition));
        }
        return filter;
    }

    public static Expression convertPartitionDataToDataFilter(MixedTable table, int specId, StructLike partition) {
        PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById(table, specId);
        Schema schema = table.schema();
        True filter = Expressions.alwaysTrue();
        for (int i = 0; i < spec.fields().size(); ++i) {
            PartitionField partitionField = (PartitionField)spec.fields().get(i);
            Types.NestedField sourceField = schema.findField(partitionField.sourceId());
            UnboundTerm transform = Expressions.transform((String)sourceField.name(), (Transform)partitionField.transform());
            Class resultType = partitionField.transform().getResultType(sourceField.type()).typeId().javaClass();
            Object partitionValue = partition.get(i, resultType);
            filter = partitionValue != null ? Expressions.and((Expression)filter, (Expression)Expressions.equal((UnboundTerm)transform, (Object)partitionValue)) : Expressions.and((Expression)filter, (Expression)Expressions.isNull((UnboundTerm)transform));
        }
        return filter;
    }
}

