/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.commons.lang3.StringUtils;

public class OptimizingInputProperties {
    public static final String ENABLE_SPILL_MAP = "enable_spill_map";
    public static final String MAX_IN_MEMORY_SIZE_IN_BYTES = "max_size_in_memory";
    public static final String SPILL_MAP_PATH = "spill_map_path";
    public static final String OUTPUT_DIR = "output_location";
    public static final String MOVE_FILE_TO_HIVE_LOCATION = "move-files-to-hive-location";
    public static final String TASK_EXECUTOR_FACTORY_IMPL = "task-executor-factory-impl";
    private final Map<String, String> properties;

    private OptimizingInputProperties(Map<String, String> properties) {
        this.properties = Maps.newHashMap(properties);
    }

    public OptimizingInputProperties() {
        this.properties = new HashMap<String, String>();
    }

    public static OptimizingInputProperties parse(Map<String, String> properties) {
        return new OptimizingInputProperties(properties);
    }

    public OptimizingInputProperties enableSpillMap() {
        this.properties.put(ENABLE_SPILL_MAP, "true");
        return this;
    }

    public OptimizingInputProperties setMaxSizeInMemory(long maxSizeInMemory) {
        this.properties.put(MAX_IN_MEMORY_SIZE_IN_BYTES, String.valueOf(maxSizeInMemory));
        return this;
    }

    public OptimizingInputProperties setSpillMapPath(String path) {
        this.properties.put(SPILL_MAP_PATH, path);
        return this;
    }

    public OptimizingInputProperties setOutputDir(String outputDir) {
        this.properties.put(OUTPUT_DIR, outputDir);
        return this;
    }

    public OptimizingInputProperties setExecutorFactoryImpl(String executorFactoryImpl) {
        this.properties.put(TASK_EXECUTOR_FACTORY_IMPL, executorFactoryImpl);
        return this;
    }

    public OptimizingInputProperties needMoveFile2HiveLocation() {
        this.properties.put(MOVE_FILE_TO_HIVE_LOCATION, "true");
        return this;
    }

    public StructLikeCollections getStructLikeCollections() {
        String enableSpillMapStr = this.properties.get(ENABLE_SPILL_MAP);
        boolean enableSpillMap = Boolean.parseBoolean(enableSpillMapStr);
        String maxInMemoryStr = this.properties.get(MAX_IN_MEMORY_SIZE_IN_BYTES);
        Long maxInMemory = maxInMemoryStr == null ? null : Long.valueOf(Long.parseLong(maxInMemoryStr));
        String spillMapPath = this.properties.get(SPILL_MAP_PATH);
        return new StructLikeCollections(enableSpillMap, maxInMemory, spillMapPath);
    }

    public String getOutputDir() {
        return this.properties.get(OUTPUT_DIR);
    }

    public String getExecutorFactoryImpl() {
        return this.properties.get(TASK_EXECUTOR_FACTORY_IMPL);
    }

    public boolean getMoveFile2HiveLocation() {
        String s = this.properties.get(MOVE_FILE_TO_HIVE_LOCATION);
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        return Boolean.parseBoolean(s);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

