/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.CloseablePredicate;
import org.apache.amoro.io.reader.StructForDelete;
import org.apache.amoro.io.reader.StructLikeFunnel;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableSet;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.hash.BloomFilter;
import org.apache.amoro.shade.guava32.com.google.common.hash.Funnel;
import org.apache.amoro.utils.ContentFiles;
import org.apache.amoro.utils.map.StructLikeBaseMap;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.Filter;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.roaringbitmap.longlong.Roaring64Bitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CombinedDeleteFilter<T extends StructLike> {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedDeleteFilter.class);
    private static final Schema POS_DELETE_SCHEMA = DeleteSchemaUtil.pathPosSchema();
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POS_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POS_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());
    @VisibleForTesting
    public static long FILTER_EQ_DELETE_TRIGGER_RECORD_COUNT = 1000000L;
    private final RewriteFilesInput input;
    private final List<DeleteFile> posDeletes;
    private final List<DeleteFile> eqDeletes;
    private Map<String, Roaring64Bitmap> positionMap;
    private final Set<String> positionPathSets;
    private Set<Integer> deleteIds = new HashSet<Integer>();
    private CloseablePredicate<StructForDelete<T>> eqPredicate;
    private final Schema deleteSchema;
    private StructLikeCollections structLikeCollections = StructLikeCollections.DEFAULT;
    private final long dataRecordCnt;
    private final boolean filterEqDelete;

    protected CombinedDeleteFilter(RewriteFilesInput rewriteFilesInput, Schema tableSchema, StructLikeCollections structLikeCollections) {
        this.input = rewriteFilesInput;
        this.dataRecordCnt = Arrays.stream(rewriteFilesInput.dataFiles()).mapToLong(ContentFile::recordCount).sum();
        ImmutableList.Builder posDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder eqDeleteBuilder = ImmutableList.builder();
        if (rewriteFilesInput.deleteFiles() != null) {
            String firstDeleteFilePath = null;
            block4: for (ContentFile<?> delete : rewriteFilesInput.deleteFiles()) {
                switch (delete.content()) {
                    case POSITION_DELETES: {
                        posDeleteBuilder.add((Object)ContentFiles.asDeleteFile(delete));
                        continue block4;
                    }
                    case EQUALITY_DELETES: {
                        if (this.deleteIds.isEmpty()) {
                            this.deleteIds = ImmutableSet.copyOf((Collection)ContentFiles.asDeleteFile(delete).equalityFieldIds());
                            firstDeleteFilePath = delete.path().toString();
                        } else {
                            ImmutableSet currentDeleteIds = ImmutableSet.copyOf((Collection)ContentFiles.asDeleteFile(delete).equalityFieldIds());
                            if (!this.deleteIds.equals(currentDeleteIds)) {
                                throw new IllegalArgumentException(String.format("Equality delete files have different delete fields, first equality field ids:[%s], current equality field ids:[%s], first delete file path:[%s],  current delete file path: [%s].", this.deleteIds, currentDeleteIds, firstDeleteFilePath, delete.path().toString()));
                            }
                        }
                        eqDeleteBuilder.add((Object)ContentFiles.asDeleteFile(delete));
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown delete file content: " + delete.content());
                    }
                }
            }
        }
        this.positionPathSets = Arrays.stream(rewriteFilesInput.dataFiles()).map(s -> s.path().toString()).collect(Collectors.toSet());
        this.posDeletes = posDeleteBuilder.build();
        this.eqDeletes = eqDeleteBuilder.build();
        this.deleteSchema = TypeUtil.select((Schema)tableSchema, this.deleteIds);
        if (structLikeCollections != null) {
            this.structLikeCollections = structLikeCollections;
        }
        this.filterEqDelete = this.filterEqDelete();
    }

    private boolean filterEqDelete() {
        long eqDeleteRecordCnt = Arrays.stream(this.input.deleteFiles()).filter((? super T file) -> file.content() == FileContent.EQUALITY_DELETES).mapToLong(ContentFile::recordCount).sum();
        return eqDeleteRecordCnt > FILTER_EQ_DELETE_TRIGGER_RECORD_COUNT;
    }

    @VisibleForTesting
    public boolean isFilterEqDelete() {
        return this.filterEqDelete;
    }

    protected abstract InputFile getInputFile(ContentFile<?> var1);

    protected abstract AuthenticatedFileIO getFileIO();

    public Set<Integer> deleteIds() {
        return this.deleteIds;
    }

    public boolean hasPosition() {
        return this.posDeletes != null && this.posDeletes.size() > 0;
    }

    public void close() {
        this.positionMap = null;
        try {
            if (this.eqPredicate != null) {
                this.eqPredicate.close();
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        this.eqPredicate = null;
    }

    public CloseableIterable<StructForDelete<T>> filter(CloseableIterable<StructForDelete<T>> records) {
        return this.applyEqDeletes(this.applyPosDeletes(records));
    }

    public CloseableIterable<StructForDelete<T>> filterNegate(CloseableIterable<StructForDelete<T>> records) {
        Predicate<StructForDelete<StructForDelete<T>>> inEq = this.applyEqDeletes();
        Predicate<StructForDelete<T>> inPos = this.applyPosDeletes();
        final Predicate<StructForDelete<T>> or = inEq.or(inPos);
        Filter remainingRowsFilter = new Filter<StructForDelete<T>>(){

            protected boolean shouldKeep(StructForDelete<T> item) {
                return or.test(item);
            }
        };
        return remainingRowsFilter.filter(records);
    }

    private Predicate<StructForDelete<T>> applyEqDeletes() {
        if (this.eqPredicate != null) {
            return this.eqPredicate;
        }
        if (this.eqDeletes.isEmpty()) {
            return record -> false;
        }
        InternalRecordWrapper internalRecordWrapper = new InternalRecordWrapper(this.deleteSchema.asStruct());
        BloomFilter bloomFilter = null;
        if (this.filterEqDelete) {
            LOG.debug("Enable bloom-filter to filter eq-delete, (rewrite + rewrite pos) data count is {}", (Object)this.dataRecordCnt);
            bloomFilter = BloomFilter.create((Funnel)StructLikeFunnel.INSTANCE, (long)this.dataRecordCnt, (double)0.001);
            try (CloseableIterable deletes = CloseableIterable.concat((Iterable)CloseableIterable.transform((CloseableIterable)CloseableIterable.withNoopClose((Iterable)Arrays.stream(this.input.dataFiles()).collect(Collectors.toList())), s -> this.openFile((ContentFile<?>)s, this.deleteSchema)));){
                for (Throwable record2 : deletes) {
                    InternalRecordWrapper identifier = internalRecordWrapper.copyFor((StructLike)record2);
                    bloomFilter.put((Object)identifier);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        CloseableIterable deleteRecords = CloseableIterable.transform((CloseableIterable)CloseableIterable.concat((Iterable)Iterables.transform(this.eqDeletes, s -> CloseableIterable.transform(this.openFile((ContentFile<?>)s, this.deleteSchema), r -> new RecordWithLsn(s.dataSequenceNumber(), (Record)r)))), RecordWithLsn::recordCopy);
        StructLikeBaseMap<Long> structLikeMap = this.structLikeCollections.createStructLikeMap(this.deleteSchema.asStruct());
        try {
            Throwable record2;
            record2 = null;
            try (CloseableIterable deletes = deleteRecords;){
                CloseableIterator it;
                Object object = it = this.getFileIO() == null ? deletes.iterator() : (Iterator)this.getFileIO().doAs(() -> ((CloseableIterable)deletes).iterator());
                while (it.hasNext()) {
                    RecordWithLsn recordWithLsn = (RecordWithLsn)it.next();
                    InternalRecordWrapper deletePK = internalRecordWrapper.copyFor((StructLike)recordWithLsn.getRecord());
                    if (this.filterEqDelete && !bloomFilter.mightContain((Object)deletePK)) continue;
                    Long lsn = recordWithLsn.getLsn();
                    Long old = (Long)structLikeMap.get((StructLike)deletePK);
                    if (old != null && old.compareTo(lsn) > 0) continue;
                    structLikeMap.put((StructLike)deletePK, lsn);
                }
            }
            catch (Throwable throwable) {
                record2 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Predicate<StructForDelete<T>> isInDeleteSet = structForDelete -> {
            InternalRecordWrapper dataPk = internalRecordWrapper.copyFor(structForDelete.getPk());
            Long dataLSN = structForDelete.getLsn();
            Long deleteLsn = (Long)structLikeMap.get((StructLike)dataPk);
            if (deleteLsn == null) {
                return false;
            }
            return deleteLsn.compareTo(dataLSN) > 0;
        };
        CloseablePredicate<StructForDelete> closeablePredicate = new CloseablePredicate<StructForDelete>(isInDeleteSet, structLikeMap);
        this.eqPredicate = closeablePredicate;
        return isInDeleteSet;
    }

    private CloseableIterable<StructForDelete<T>> applyEqDeletes(CloseableIterable<StructForDelete<T>> records) {
        Predicate<StructForDelete<T>> remainingRows = this.applyEqDeletes().negate();
        return this.eqDeletesBase(records, remainingRows);
    }

    private CloseableIterable<StructForDelete<T>> eqDeletesBase(CloseableIterable<StructForDelete<T>> records, final Predicate<StructForDelete<T>> predicate) {
        if (this.eqDeletes.isEmpty()) {
            return records;
        }
        Filter remainingRowsFilter = new Filter<StructForDelete<T>>(){

            protected boolean shouldKeep(StructForDelete<T> item) {
                return predicate.test(item);
            }
        };
        return remainingRowsFilter.filter(records);
    }

    private CloseableIterable<StructForDelete<T>> applyPosDeletes(CloseableIterable<StructForDelete<T>> records) {
        return this.applyPosDeletesBase(records, this.applyPosDeletes().negate());
    }

    private Predicate<StructForDelete<T>> applyPosDeletes() {
        if (this.posDeletes.isEmpty()) {
            return record -> false;
        }
        if (this.positionMap == null) {
            this.positionMap = new HashMap<String, Roaring64Bitmap>();
            List deletes = Lists.transform(this.posDeletes, this::openPosDeletes);
            for (Record deleteRecord : CloseableIterable.concat((Iterable)deletes)) {
                String path = FILENAME_ACCESSOR.get((Object)deleteRecord).toString();
                if (this.positionPathSets != null && !this.positionPathSets.contains(path)) continue;
                Roaring64Bitmap posBitMap = this.positionMap.computeIfAbsent(path, k -> new Roaring64Bitmap());
                posBitMap.add(new long[]{(Long)POSITION_ACCESSOR.get((Object)deleteRecord)});
            }
        }
        return structLikeForDelete -> {
            Roaring64Bitmap posSet = this.positionMap.get(structLikeForDelete.filePath());
            if (posSet == null || posSet.isEmpty()) {
                return false;
            }
            return posSet.contains(structLikeForDelete.getPosition().longValue());
        };
    }

    private CloseableIterable<StructForDelete<T>> applyPosDeletesBase(CloseableIterable<StructForDelete<T>> records, final Predicate<StructForDelete<T>> predicate) {
        if (this.posDeletes.isEmpty()) {
            return records;
        }
        Filter filter = new Filter<StructForDelete<T>>(){

            protected boolean shouldKeep(StructForDelete<T> item) {
                return predicate.test(item);
            }
        };
        return filter.filter(records);
    }

    private CloseableIterable<Record> openPosDeletes(DeleteFile file) {
        return this.openFile((ContentFile<?>)file, POS_DELETE_SCHEMA);
    }

    private CloseableIterable<Record> openFile(ContentFile<?> contentFile, Schema deleteSchema) {
        InputFile input = this.getInputFile(contentFile);
        switch (contentFile.format()) {
            case AVRO: {
                return Avro.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(DataReader::create).build();
            }
            case PARQUET: {
                return Parquet.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)deleteSchema, (MessageType)fileSchema)).build();
            }
            case ORC: {
                return ORC.read((InputFile)input).project(deleteSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)deleteSchema, (TypeDescription)fileSchema)).build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", contentFile.format().name(), contentFile.path()));
    }

    static class RecordWithLsn {
        private final Long lsn;
        private Record record;

        public RecordWithLsn(Long lsn, Record record) {
            this.lsn = lsn;
            this.record = record;
        }

        public Long getLsn() {
            return this.lsn;
        }

        public Record getRecord() {
            return this.record;
        }

        public RecordWithLsn recordCopy() {
            this.record = this.record.copy();
            return this;
        }
    }
}

