/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.mixed;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.FormatCatalog;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.TableFormat;
import org.apache.amoro.formats.mixed.MixedTable;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.table.TableIdentifier;

public class MixedCatalog
implements FormatCatalog {
    final MixedFormatCatalog catalog;
    final TableFormat format;

    public MixedCatalog(MixedFormatCatalog catalog, TableFormat format) {
        this.catalog = catalog;
        this.format = format;
    }

    @Override
    public List<String> listDatabases() {
        return this.catalog.listDatabases();
    }

    @Override
    public boolean databaseExists(String database) {
        return this.catalog.listDatabases().contains(database);
    }

    @Override
    public boolean tableExists(String database, String table) {
        return this.catalog.tableExists(TableIdentifier.of(this.catalog.name(), database, table));
    }

    @Override
    public void createDatabase(String database) {
        this.catalog.createDatabase(database);
    }

    @Override
    public void dropDatabase(String database) {
        this.catalog.dropDatabase(database);
    }

    @Override
    public AmoroTable<?> loadTable(String database, String table) {
        try {
            org.apache.amoro.table.MixedTable mixedTable = this.catalog.loadTable(TableIdentifier.of(this.catalog.name(), database, table));
            return new MixedTable(mixedTable, this.format);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(e);
        }
    }

    @Override
    public List<String> listTables(String database) {
        return this.catalog.listTables(database).stream().map(TableIdentifier::getTableName).collect(Collectors.toList());
    }

    @Override
    public boolean dropTable(String database, String table, boolean purge) {
        return this.catalog.dropTable(TableIdentifier.of(this.catalog.name(), database, table), purge);
    }
}

