/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.errors.QueryParsingErrors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class ParserUtils$ {
    public static ParserUtils$ MODULE$;
    private final Regex U16_CHAR_PATTERN;
    private final Regex U32_CHAR_PATTERN;
    private final Regex OCTAL_CHAR_PATTERN;
    private final Regex ESCAPED_CHAR_PATTERN;
    private final Regex escapedIdentifier;
    private final Regex qualifiedEscapedIdentifier;

    static {
        new ParserUtils$();
    }

    public Regex U16_CHAR_PATTERN() {
        return this.U16_CHAR_PATTERN;
    }

    public Regex U32_CHAR_PATTERN() {
        return this.U32_CHAR_PATTERN;
    }

    public Regex OCTAL_CHAR_PATTERN() {
        return this.OCTAL_CHAR_PATTERN;
    }

    public Regex ESCAPED_CHAR_PATTERN() {
        return this.ESCAPED_CHAR_PATTERN;
    }

    public String command(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)0, (int)(stream.size() - 1)));
    }

    public Nothing$ operationNotAllowed(String message, ParserRuleContext ctx) {
        throw QueryParsingErrors$.MODULE$.operationNotAllowedError(message, ctx);
    }

    public <T> void checkDuplicateClauses(List<T> nodes, String clauseName, ParserRuleContext ctx) {
        if (nodes.size() > 1) {
            throw QueryParsingErrors$.MODULE$.duplicateClausesError(clauseName, ctx);
        }
    }

    public <T> void checkDuplicateKeys(Seq<Tuple2<String, T>> keyPairs, ParserRuleContext ctx) {
        ((IterableLike)keyPairs.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParserUtils$.$anonfun$checkDuplicateKeys$2(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                throw QueryParsingErrors$.MODULE$.duplicateKeysError(key, ctx);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String source(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
    }

    public String remainder(ParserRuleContext ctx) {
        return this.remainder(ctx.getStop());
    }

    public String remainder(Token token) {
        CharStream stream = token.getInputStream();
        Interval interval = Interval.of((int)(token.getStopIndex() + 1), (int)(stream.size() - 1));
        return stream.getText(interval);
    }

    public String interval(Token start, Token end) {
        Interval interval = Interval.of((int)(start.getStopIndex() + 1), (int)(end.getStartIndex() - 1));
        return start.getInputStream().getText(interval);
    }

    public String string(Token token) {
        return this.unescapeSQLString(token.getText());
    }

    public String string(TerminalNode node) {
        return this.unescapeSQLString(node.getText());
    }

    public String stringWithoutUnescape(TerminalNode node) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(node.getText()), 1, new StringOps(Predef$.MODULE$.augmentString(node.getText())).size() - 1);
    }

    public Seq<Tuple2<String, String>> entry(String key, Token value) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)value)).toSeq().map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.string((Token)x)), Seq$.MODULE$.canBuildFrom());
    }

    public Origin position(Token token) {
        Option opt = Option$.MODULE$.apply((Object)token);
        return new Origin((Option<Object>)opt.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.getLine())), (Option<Object>)opt.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.getCharPositionInLine())));
    }

    public void validate(Function0<Object> f, String message, ParserRuleContext ctx) {
        if (!f.apply$mcZ$sp()) {
            throw new ParseException(message, ctx);
        }
    }

    public <T> T withOrigin(ParserRuleContext ctx, Function0<T> f) {
        Object object;
        Origin current = CurrentOrigin$.MODULE$.get();
        CurrentOrigin$.MODULE$.set(this.position(ctx.getStart()));
        try {
            object = f.apply();
        }
        finally {
            CurrentOrigin$.MODULE$.set(current);
        }
        return (T)object;
    }

    public String unescapeSQLString(String b) {
        StringBuilder sb = new StringBuilder(b.length());
        CharBuffer charBuffer = CharBuffer.wrap(b, 1, b.length() - 1);
        while (charBuffer.remaining() > 0) {
            Buffer buffer;
            CharBuffer charBuffer2 = charBuffer;
            Option option = this.U16_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String cp = (String)((LinearSeqOptimized)option.get()).apply(0);
                sb.append((char)Integer.parseInt(cp, 16));
                buffer = charBuffer.position(charBuffer.position() + 6);
                continue;
            }
            Option option2 = this.U32_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                StringBuilder stringBuilder;
                String cp = (String)((LinearSeqOptimized)option2.get()).apply(0);
                long codePoint = Long.parseLong(cp, 16);
                if (codePoint < 65536L) {
                    stringBuilder = sb.append((char)(codePoint & 0xFFFFL));
                } else {
                    long highSurrogate = (codePoint - 65536L) / 1024L + 55296L;
                    long lowSurrogate = (codePoint - 65536L) % 1024L + 56320L;
                    sb.append((char)highSurrogate);
                    stringBuilder = sb.append((char)lowSurrogate);
                }
                buffer = charBuffer.position(charBuffer.position() + 10);
                continue;
            }
            Option option3 = this.OCTAL_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                String cp = (String)((LinearSeqOptimized)option3.get()).apply(0);
                sb.append((char)Integer.parseInt(cp, 8));
                buffer = charBuffer.position(charBuffer.position() + 4);
                continue;
            }
            Option option4 = this.ESCAPED_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                String c = (String)((LinearSeqOptimized)option4.get()).apply(0);
                ParserUtils$.appendEscapedChar$1(c.charAt(0), sb);
                buffer = charBuffer.position(charBuffer.position() + 2);
                continue;
            }
            buffer = sb.append(charBuffer.get());
        }
        return sb.toString();
    }

    public Regex escapedIdentifier() {
        return this.escapedIdentifier;
    }

    public Regex qualifiedEscapedIdentifier() {
        return this.qualifiedEscapedIdentifier;
    }

    public LogicalPlan EnhancedLogicalPlan(LogicalPlan plan2) {
        return plan2;
    }

    public static final /* synthetic */ boolean $anonfun$checkDuplicateKeys$2(Tuple2 x$2) {
        return ((SeqLike)x$2._2()).size() > 1;
    }

    private static final void appendEscapedChar$1(char n, StringBuilder sb$1) {
        char c = n;
        switch (c) {
            case '0': {
                sb$1.append('\u0000');
                break;
            }
            case '\'': {
                sb$1.append('\'');
                break;
            }
            case '\"': {
                sb$1.append('\"');
                break;
            }
            case 'b': {
                sb$1.append('\b');
                break;
            }
            case 'n': {
                sb$1.append('\n');
                break;
            }
            case 'r': {
                sb$1.append('\r');
                break;
            }
            case 't': {
                sb$1.append('\t');
                break;
            }
            case 'Z': {
                sb$1.append('\u001a');
                break;
            }
            case '\\': {
                sb$1.append('\\');
                break;
            }
            case '%': {
                sb$1.append("\\%");
                break;
            }
            case '_': {
                sb$1.append("\\_");
                break;
            }
            default: {
                sb$1.append(n);
                break;
            }
        }
    }

    private ParserUtils$() {
        MODULE$ = this;
        this.U16_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\u([a-fA-F0-9]{4})(?s).*")).r();
        this.U32_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\U([a-fA-F0-9]{8})(?s).*")).r();
        this.OCTAL_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\([01][0-7]{2})(?s).*")).r();
        this.ESCAPED_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\((?s).)(?s).*")).r();
        this.escapedIdentifier = new StringOps(Predef$.MODULE$.augmentString("`((?s).+)`")).r();
        this.qualifiedEscapedIdentifier = new StringOps(Predef$.MODULE$.augmentString("((?s).+).`((?s).+)`")).r();
    }
}

