/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestEntrySerializer;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class IndexManifestFile
extends ObjectsFile<IndexManifestEntry> {
    private IndexManifestFile(FileIO fileIO, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, PathFactory pathFactory) {
        super(fileIO, new IndexManifestEntrySerializer(), readerFactory, writerFactory, pathFactory, null);
    }

    @Nullable
    public String merge(@Nullable String previousIndexManifest, List<IndexManifestEntry> newIndexFiles) {
        String indexManifest = previousIndexManifest;
        if (newIndexFiles.size() > 0) {
            LinkedHashMap<IndexManifestEntry.Identifier, IndexManifestEntry> indexEntries = new LinkedHashMap<IndexManifestEntry.Identifier, IndexManifestEntry>();
            List<Object> entries = indexManifest == null ? new ArrayList() : this.read(indexManifest);
            entries.addAll(newIndexFiles);
            for (IndexManifestEntry indexManifestEntry : entries) {
                if (indexManifestEntry.kind() == FileKind.ADD) {
                    indexEntries.put(indexManifestEntry.identifier(), indexManifestEntry);
                    continue;
                }
                indexEntries.remove(indexManifestEntry.identifier());
            }
            indexManifest = this.writeWithoutRolling(indexEntries.values());
        }
        return indexManifest;
    }

    public static class Factory {
        private final FileIO fileIO;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;

        public Factory(FileIO fileIO, FileFormat fileFormat, FileStorePathFactory pathFactory) {
            this.fileIO = fileIO;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
        }

        public IndexManifestFile create() {
            RowType schema = VersionedObjectSerializer.versionType(IndexManifestEntry.schema());
            return new IndexManifestFile(this.fileIO, this.fileFormat.createReaderFactory(schema), this.fileFormat.createWriterFactory(schema), this.pathFactory.indexManifestFileFactory());
        }
    }
}

