/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.jdbc.JdbcClientPool;
import org.apache.paimon.jdbc.JdbcUtils;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.utils.TimeUtils;

public class JdbcCatalogLock
implements CatalogLock {
    private final JdbcClientPool connections;
    private final long checkMaxSleep;
    private final long acquireTimeout;
    private final String catalogKey;

    public JdbcCatalogLock(JdbcClientPool connections, String catalogKey, long checkMaxSleep, long acquireTimeout) {
        this.connections = connections;
        this.checkMaxSleep = checkMaxSleep;
        this.acquireTimeout = acquireTimeout;
        this.catalogKey = catalogKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runWithLock(String database, String table, Callable<T> callable) throws Exception {
        String lockUniqueName = String.format("%s.%s.%s", this.catalogKey, database, table);
        this.lock(lockUniqueName);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            JdbcUtils.release(this.connections, lockUniqueName);
        }
    }

    private void lock(String lockUniqueName) throws SQLException, InterruptedException {
        boolean lock = JdbcUtils.acquire(this.connections, lockUniqueName, this.acquireTimeout);
        long nextSleep = 50L;
        long startRetry = System.currentTimeMillis();
        while (!lock) {
            if ((nextSleep *= 2L) > this.checkMaxSleep) {
                nextSleep = this.checkMaxSleep;
            }
            Thread.sleep(nextSleep);
            lock = JdbcUtils.acquire(this.connections, lockUniqueName, this.acquireTimeout);
            if (System.currentTimeMillis() - startRetry <= this.acquireTimeout) continue;
        }
        long retryDuration = System.currentTimeMillis() - startRetry;
        if (!lock) {
            throw new RuntimeException("Acquire lock failed with time: " + Duration.ofMillis(retryDuration));
        }
    }

    @Override
    public void close() throws IOException {
    }

    public static long checkMaxSleep(Map<String, String> conf) {
        return TimeUtils.parseDuration(conf.getOrDefault(CatalogOptions.LOCK_CHECK_MAX_SLEEP.key(), TimeUtils.getStringInMillis(CatalogOptions.LOCK_CHECK_MAX_SLEEP.defaultValue()))).toMillis();
    }

    public static long acquireTimeout(Map<String, String> conf) {
        return TimeUtils.parseDuration(conf.getOrDefault(CatalogOptions.LOCK_ACQUIRE_TIMEOUT.key(), TimeUtils.getStringInMillis(CatalogOptions.LOCK_ACQUIRE_TIMEOUT.defaultValue()))).toMillis();
    }
}

