/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.Path;

@ThreadSafe
public class DataFilePathFactory {
    public static final String DATA_FILE_PREFIX = "data-";
    public static final String CHANGELOG_FILE_PREFIX = "changelog-";
    public static final String INDEX_PATH_SUFFIX = ".index";
    private final Path parent;
    private final String uuid;
    private final AtomicInteger pathCount;
    private final String formatIdentifier;

    public DataFilePathFactory(Path parent, String formatIdentifier) {
        this.parent = parent;
        this.uuid = UUID.randomUUID().toString();
        this.pathCount = new AtomicInteger(0);
        this.formatIdentifier = formatIdentifier;
    }

    public Path newPath() {
        return this.newPath(DATA_FILE_PREFIX);
    }

    public Path newChangelogPath() {
        return this.newPath(CHANGELOG_FILE_PREFIX);
    }

    private Path newPath(String prefix) {
        String name = prefix + this.uuid + "-" + this.pathCount.getAndIncrement() + "." + this.formatIdentifier;
        return new Path(this.parent, name);
    }

    public Path toPath(String fileName) {
        return new Path(this.parent + "/" + fileName);
    }

    @VisibleForTesting
    public String uuid() {
        return this.uuid;
    }

    public static Path toFileIndexPath(Path filePath) {
        return new Path(filePath.getParent(), filePath.getName() + INDEX_PATH_SUFFIX);
    }

    public static String formatIdentifier(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException(fileName + " is not a legal file name.");
        }
        return fileName.substring(index + 1);
    }
}

