/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.parquet.writer.ParquetBuilder;
import org.apache.paimon.format.parquet.writer.ParquetBulkWriter;
import org.apache.paimon.format.parquet.writer.StreamOutputFile;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetWriter;

public class ParquetWriterFactory
implements FormatWriterFactory {
    private final ParquetBuilder<InternalRow> writerBuilder;

    public ParquetWriterFactory(ParquetBuilder<InternalRow> writerBuilder) {
        this.writerBuilder = writerBuilder;
    }

    @Override
    public FormatWriter create(PositionOutputStream stream, String compression) throws IOException {
        StreamOutputFile out = new StreamOutputFile(stream);
        ParquetWriter<InternalRow> writer = this.writerBuilder.createWriter(out, compression);
        return new ParquetBulkWriter(writer);
    }
}

