/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Spigot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Spigot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Spigot.getter(Spigot::name)).setter(Spigot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(Spigot.getter(Spigot::inputs)).setter(Spigot.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(Spigot.getter(Spigot::path)).setter(Spigot.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Integer> TOPK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Topk").getter(Spigot.getter(Spigot::topk)).setter(Spigot.setter(Builder::topk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topk").build()}).build();
    private static final SdkField<Double> PROB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Prob").getter(Spigot.getter(Spigot::prob)).setter(Spigot.setter(Builder::prob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, PATH_FIELD, TOPK_FIELD, PROB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String path;
    private final Integer topk;
    private final Double prob;

    private Spigot(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.path = builder.path;
        this.topk = builder.topk;
        this.prob = builder.prob;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final String path() {
        return this.path;
    }

    public final Integer topk() {
        return this.topk;
    }

    public final Double prob() {
        return this.prob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.topk());
        hashCode = 31 * hashCode + Objects.hashCode(this.prob());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spigot)) {
            return false;
        }
        Spigot other = (Spigot)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.topk(), other.topk()) && Objects.equals(this.prob(), other.prob());
    }

    public final String toString() {
        return ToString.builder((String)"Spigot").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Path", (Object)this.path()).add("Topk", (Object)this.topk()).add("Prob", (Object)this.prob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Topk": {
                return Optional.ofNullable(clazz.cast(this.topk()));
            }
            case "Prob": {
                return Optional.ofNullable(clazz.cast(this.prob()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Spigot, T> g) {
        return obj -> g.apply((Spigot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String path;
        private Integer topk;
        private Double prob;

        private BuilderImpl() {
        }

        private BuilderImpl(Spigot model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.path(model.path);
            this.topk(model.topk);
            this.prob(model.prob);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getTopk() {
            return this.topk;
        }

        public final void setTopk(Integer topk) {
            this.topk = topk;
        }

        @Override
        public final Builder topk(Integer topk) {
            this.topk = topk;
            return this;
        }

        public final Double getProb() {
            return this.prob;
        }

        public final void setProb(Double prob) {
            this.prob = prob;
        }

        @Override
        public final Builder prob(Double prob) {
            this.prob = prob;
            return this;
        }

        public Spigot build() {
            return new Spigot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Spigot> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder path(String var1);

        public Builder topk(Integer var1);

        public Builder prob(Double var1);
    }
}

